/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class AnalyticsException
extends CouchbaseException {
    private final List<ErrorCodeAndMessage> errors;
    private final byte[] content;

    protected AnalyticsException(AnalyticsException cause) {
        super(cause.getMessage(), cause);
        this.content = cause.content;
        this.errors = cause.errors;
    }

    public AnalyticsException(byte[] content) {
        this(content, null);
    }

    public AnalyticsException(byte[] content, Throwable cause) {
        super("Analytics Query Failed: " + new String(content, StandardCharsets.UTF_8), cause);
        this.content = Objects.requireNonNull(content);
        this.errors = ErrorCodeAndMessage.fromJsonArray(content);
    }

    @Stability.Internal
    public byte[] content() {
        return this.content;
    }

    public List<ErrorCodeAndMessage> errors() {
        return this.errors;
    }

    public boolean hasErrorCode(int code) {
        return this.errors.stream().anyMatch(e -> e.code() == code);
    }
}

