/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

public class DesignDocumentNotFoundException
extends CouchbaseException {
    private final String name;
    private final String namespace;

    private DesignDocumentNotFoundException(String name, String namespace) {
        super("Design document [" + RedactableArgument.redactMeta(name) + "] not found in namespace " + namespace + ".");
        this.name = Objects.requireNonNull(name);
        this.namespace = Objects.requireNonNull(namespace);
    }

    public static DesignDocumentNotFoundException forName(String name, String namespace) {
        return new DesignDocumentNotFoundException(name, namespace);
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.namespace;
    }
}

