/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.ResponseStatus;
import java.util.Map;

@Stability.Uncommitted
public class SearchErrorContext
extends ErrorContext {
    private final RequestContext requestContext;
    private final int httpStatus;
    private final String content;

    public SearchErrorContext(ResponseStatus responseStatus, RequestContext requestContext, int httpStatus, String content) {
        super(responseStatus);
        this.requestContext = requestContext;
        this.httpStatus = httpStatus;
        this.content = content;
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public String content() {
        return this.content;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.requestContext != null) {
            this.requestContext.injectExportableParams(input);
        }
        input.put("httpStatus", this.httpStatus);
        if (this.content != null) {
            input.put("httpBody", this.content);
        }
    }
}

