/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.view;

import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ViewErrorContext;
import com.couchbase.client.core.io.netty.chunk.ChunkedMessageHandler;
import com.couchbase.client.core.io.netty.view.ViewChunkResponseParser;
import com.couchbase.client.core.msg.view.ViewChunkHeader;
import com.couchbase.client.core.msg.view.ViewChunkRow;
import com.couchbase.client.core.msg.view.ViewChunkTrailer;
import com.couchbase.client.core.msg.view.ViewError;
import com.couchbase.client.core.msg.view.ViewRequest;
import com.couchbase.client.core.msg.view.ViewResponse;
import com.couchbase.client.core.retry.RetryReason;
import java.util.Optional;

class ChunkedViewMessageHandler
extends ChunkedMessageHandler<ViewChunkHeader, ViewChunkRow, ViewChunkTrailer, ViewResponse, ViewRequest> {
    ChunkedViewMessageHandler(BaseEndpoint endpoint, EndpointContext endpointContext) {
        super(endpoint, endpointContext, new ViewChunkResponseParser());
    }

    @Override
    protected Optional<RetryReason> qualifiesForRetry(CouchbaseException exception) {
        if (!(exception.context() instanceof ViewErrorContext)) {
            return Optional.empty();
        }
        return ChunkedViewMessageHandler.shouldRetry((ViewErrorContext)exception.context());
    }

    private static Optional<RetryReason> shouldRetry(ViewErrorContext context) {
        switch (context.httpStatus()) {
            case 404: {
                return ChunkedViewMessageHandler.analyse404Response(context.error());
            }
            case 500: {
                return ChunkedViewMessageHandler.analyse500Response(context.error());
            }
            case 302: {
                return Optional.of(RetryReason.VIEWS_NO_ACTIVE_PARTITION);
            }
            case 300: 
            case 301: 
            case 303: 
            case 307: 
            case 401: 
            case 408: 
            case 409: 
            case 412: 
            case 416: 
            case 417: 
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return Optional.of(RetryReason.VIEWS_TEMPORARY_FAILURE);
            }
        }
        return Optional.empty();
    }

    private static Optional<RetryReason> analyse404Response(ViewError error) {
        return error.reason().equals("missing") ? Optional.of(RetryReason.VIEWS_TEMPORARY_FAILURE) : Optional.empty();
    }

    private static Optional<RetryReason> analyse500Response(ViewError error) {
        if (error.reason().contains("{not_found, missing_named_view}") || error.reason().contains("badarg")) {
            return Optional.empty();
        }
        return Optional.of(RetryReason.VIEWS_TEMPORARY_FAILURE);
    }
}

