/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.RemoveResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class RemoveRequest
extends BaseKeyValueRequest<RemoveResponse>
implements SyncDurabilityRequest {
    private final long cas;
    private final Optional<DurabilityLevel> syncReplicationType;

    public RemoveRequest(String key, long cas, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.cas = cas;
        this.syncReplicationType = syncReplicationType;
        if (span != null && !CbTracing.isInternalSpan(span)) {
            span.lowCardinalityAttribute("db.operation", "remove");
            this.applyLevelOnSpan(syncReplicationType, span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf flexibleExtras = MemcacheProtocol.mutationFlexibleExtras(this, ctx, alloc, this.syncReplicationType);
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            byteBuf = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.DELETE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, flexibleExtras, MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(flexibleExtras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(flexibleExtras);
        return byteBuf;
    }

    @Override
    public RemoveResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        Optional<MutationToken> mutationToken = MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get());
        return new RemoveResponse(status, MemcacheProtocol.cas(response), mutationToken, MemcacheProtocol.flexibleExtras(response));
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }

    @Override
    public String name() {
        return "remove";
    }
}

