/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.manager;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.manager.BaseManagerRequest;
import com.couchbase.client.core.msg.manager.BucketConfigStreamingResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class BucketConfigStreamingRequest
extends BaseManagerRequest<BucketConfigStreamingResponse> {
    private static final String PATH = "/pools/default/bs/{}";
    private final String bucketName;
    private final Authenticator authenticator;

    public BucketConfigStreamingRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String bucketName, Authenticator authenticator) {
        super(timeout, ctx, retryStrategy);
        this.bucketName = bucketName;
        this.authenticator = authenticator;
    }

    @Override
    public BucketConfigStreamingResponse decode(HttpResponse response, byte[] content) {
        String lastDispatchedTo = null;
        if (this.context().lastDispatchedTo() != null) {
            lastDispatchedTo = this.context().lastDispatchedTo().host();
        }
        return new BucketConfigStreamingResponse(HttpProtocol.decodeStatus(response.status()), lastDispatchedTo);
    }

    @Override
    public FullHttpRequest encode() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, CoreHttpPath.formatPath(PATH, this.bucketName));
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public boolean idempotent() {
        return true;
    }
}

