/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessors;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.kv.CoreProtoStellarKvBinaryRequests;
import com.couchbase.client.core.protostellar.kv.CoreProtostellarKvBinaryResponses;
import com.couchbase.client.protostellar.kv.v1.AppendRequest;
import com.couchbase.client.protostellar.kv.v1.DecrementRequest;
import com.couchbase.client.protostellar.kv.v1.IncrementRequest;
import com.couchbase.client.protostellar.kv.v1.KvServiceGrpc;
import com.couchbase.client.protostellar.kv.v1.PrependRequest;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ProtostellarCoreKvBinaryOps
implements CoreKvBinaryOps {
    private final CoreProtostellar core;
    private final CoreKeyspace keyspace;

    public ProtostellarCoreKvBinaryOps(CoreProtostellar core, CoreKeyspace keyspace) {
        this.core = Objects.requireNonNull(core);
        this.keyspace = Objects.requireNonNull(keyspace);
    }

    @Override
    public CoreMutationResult appendBlocking(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<AppendRequest> request = CoreProtoStellarKvBinaryRequests.appendRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).append((AppendRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> appendAsync(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<AppendRequest> request = CoreProtoStellarKvBinaryRequests.appendRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).append((AppendRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public Mono<CoreMutationResult> appendReactive(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<AppendRequest> request = CoreProtoStellarKvBinaryRequests.appendRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).append((AppendRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreMutationResult prependBlocking(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<PrependRequest> request = CoreProtoStellarKvBinaryRequests.prependRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).prepend((PrependRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> prependAsync(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<PrependRequest> request = CoreProtoStellarKvBinaryRequests.prependRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).prepend((PrependRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public Mono<CoreMutationResult> prependReactive(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        ProtostellarRequest<PrependRequest> request = CoreProtoStellarKvBinaryRequests.prependRequest(this.core, id, this.keyspace, options, content, cas, durability);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).prepend((PrependRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreCounterResult incrementBlocking(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<IncrementRequest> request = CoreProtoStellarKvBinaryRequests.incrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).increment((IncrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreAsyncResponse<CoreCounterResult> incrementAsync(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<IncrementRequest> request = CoreProtoStellarKvBinaryRequests.incrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).increment((IncrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public Mono<CoreCounterResult> incrementReactive(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<IncrementRequest> request = CoreProtoStellarKvBinaryRequests.incrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).increment((IncrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreCounterResult decrementBlocking(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<DecrementRequest> request = CoreProtoStellarKvBinaryRequests.decrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).decrement((DecrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public CoreAsyncResponse<CoreCounterResult> decrementAsync(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<DecrementRequest> request = CoreProtoStellarKvBinaryRequests.decrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).decrement((DecrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }

    @Override
    public Mono<CoreCounterResult> decrementReactive(String id, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        ProtostellarRequest<DecrementRequest> request = CoreProtoStellarKvBinaryRequests.decrementRequest(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).decrement((DecrementRequest)request.request()), response -> CoreProtostellarKvBinaryResponses.convertResponse(this.keyspace, id, response));
    }
}

