/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.error.InvalidArgumentException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Golang {
    private static final Pattern durationComponentPattern = Pattern.compile("(?:([\\d.]+)([^\\d.]*))");
    private static final Pattern durationPattern = Pattern.compile(durationComponentPattern.pattern() + "+");

    public static String encodeDurationToMs(Duration duration) {
        return duration.toMillis() + "ms";
    }

    public static Duration parseDuration(String duration) {
        String abs;
        boolean negative = duration.startsWith("-");
        String string = abs = negative || duration.startsWith("+") ? duration.substring(1) : duration;
        if (abs.equals("0")) {
            return Duration.ZERO;
        }
        try {
            Matcher validator = durationPattern.matcher(abs);
            if (!validator.matches()) {
                throw InvalidArgumentException.fromMessage("Invalid duration.");
            }
            long resultNanos = 0L;
            Matcher m = durationComponentPattern.matcher(abs);
            while (m.find()) {
                BigDecimal number = new BigDecimal(m.group(1));
                TimeUnit timeUnit = Golang.parseTimeUnit(m.group(2));
                resultNanos = Math.addExact(resultNanos, Golang.toNanosExact(number, timeUnit));
            }
            return Duration.ofNanos(negative ? -resultNanos : resultNanos);
        }
        catch (ArithmeticException e) {
            throw InvalidArgumentException.fromMessage("Duration \"" + duration + "\" is too long. Maximum duration is 2^63\u22121 nanoseconds.", e);
        }
        catch (Exception e) {
            String msg = " ; A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as \"300ms\", \"-1.5h\" or \"2h45m\". Valid time units are \"ns\", \"us\" (or \"\u00b5s\"), \"ms\", \"s\", \"m\", \"h\"";
            throw InvalidArgumentException.fromMessage("Failed to parse duration \"" + duration + "\" ; " + e + " ; A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as \"300ms\", \"-1.5h\" or \"2h45m\". Valid time units are \"ns\", \"us\" (or \"\u00b5s\"), \"ms\", \"s\", \"m\", \"h\"", e);
        }
    }

    private static long toNanosExact(BigDecimal number, TimeUnit timeUnit) {
        return number.multiply(BigDecimal.valueOf(timeUnit.toNanos(1L))).setScale(0, RoundingMode.DOWN).longValueExact();
    }

    private static TimeUnit parseTimeUnit(String unit) {
        switch (unit) {
            case "": {
                throw InvalidArgumentException.fromMessage("Missing time unit.");
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "us": 
            case "\u00b5s": 
            case "\u03bcs": {
                return TimeUnit.MICROSECONDS;
            }
            case "ns": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw InvalidArgumentException.fromMessage("Unknown unit \"" + unit + "\".");
    }
}

