/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsParams;
import com.couchbase.client.java.analytics.AnalyticsQuery;
import com.couchbase.client.java.document.json.JsonObject;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class SimpleAnalyticsQuery
extends AnalyticsQuery {
    private final String statement;
    private final AnalyticsParams params;

    SimpleAnalyticsQuery(String statement, AnalyticsParams params) {
        this.statement = statement.trim();
        this.params = params == null ? AnalyticsParams.build() : params;
    }

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public AnalyticsParams params() {
        return this.params;
    }

    @Override
    public JsonObject query() {
        JsonObject query = JsonObject.create().put("statement", this.statement);
        if (this.params != null) {
            this.params.injectParams(query);
        }
        return query;
    }
}

