/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.transactions.TransactionGetResult;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import com.couchbase.client.java.transactions.TransactionQueryResult;
import com.couchbase.client.java.transactions.config.TransactionGetOptions;
import com.couchbase.client.java.transactions.config.TransactionGetReplicaFromPreferredServerGroupOptions;
import com.couchbase.client.java.transactions.config.TransactionInsertOptions;
import com.couchbase.client.java.transactions.config.TransactionReplaceOptions;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import com.couchbase.client.java.transactions.internal.EncodingUtil;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final JsonSerializer serializer;
    private final ReactorOps reactor;

    ReactiveTransactionAttemptContext(ReactorOps reactor, CoreTransactionAttemptContext internal, JsonSerializer serializer) {
        this.reactor = Objects.requireNonNull(reactor);
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Stability.Internal
    CoreTransactionAttemptContext ctx() {
        return this.internal;
    }

    public Mono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return this.get(collection, id, TransactionGetOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> get(ReactiveCollection collection, String id, TransactionGetOptions options) {
        TransactionGetOptions.Built built = options.build();
        return this.reactor.publishOnUserScheduler(this.internal.get(ConverterUtil.makeCollectionIdentifier(collection.async()), id).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer(), built.transcoder())));
    }

    public Mono<TransactionGetResult> getReplicaFromPreferredServerGroup(ReactiveCollection collection, String id) {
        return this.getReplicaFromPreferredServerGroup(collection, id, TransactionGetReplicaFromPreferredServerGroupOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> getReplicaFromPreferredServerGroup(ReactiveCollection collection, String id, TransactionGetReplicaFromPreferredServerGroupOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        TransactionGetReplicaFromPreferredServerGroupOptions.Built built = options.build();
        return this.reactor.publishOnUserScheduler(this.internal.getReplicaFromPreferredServerGroup(ConverterUtil.makeCollectionIdentifier(collection.async()), id).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer(), built.transcoder())));
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content) {
        return this.insert(collection, id, content, TransactionInsertOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content, TransactionInsertOptions options) {
        TransactionInsertOptions.Built built = options.build();
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_insert", (RequestSpan)this.internal.span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Transcoder.EncodedValue encoded = EncodingUtil.encode(content, span, this.serializer, built.transcoder(), this.internal.core().context());
        return this.reactor.publishOnUserScheduler(this.internal.insert(ConverterUtil.makeCollectionIdentifier(collection.async()), id, encoded.encoded(), encoded.flags(), new SpanWrapper(span)).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer(), built.transcoder())).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end()));
    }

    private JsonSerializer serializer() {
        return this.serializer;
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content) {
        return this.replace(doc, content, TransactionReplaceOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content, TransactionReplaceOptions options) {
        TransactionReplaceOptions.Built built = options.build();
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_replace", (RequestSpan)this.internal.span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Transcoder.EncodedValue encoded = EncodingUtil.encode(content, span, this.serializer, built.transcoder(), this.internal.core().context());
        return this.reactor.publishOnUserScheduler(this.internal.replace(doc.internal(), encoded.encoded(), encoded.flags(), new SpanWrapper(span)).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer(), built.transcoder())).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end()));
    }

    public Mono<Void> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_remove", (RequestSpan)this.internal.span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        return this.reactor.publishOnUserScheduler(this.internal.remove(doc.internal(), new SpanWrapper(span)).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end()));
    }

    @Stability.Internal
    CoreTransactionLogger logger() {
        return this.internal.logger();
    }

    public Mono<TransactionQueryResult> query(String statement) {
        return this.query(statement, null);
    }

    public Mono<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement, TransactionQueryOptions options) {
        QueryOptions.Built opts = options != null ? options.builder().build() : null;
        return this.reactor.publishOnUserScheduler(this.internal.queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), (CoreQueryOptions)opts, false).map(response -> new TransactionQueryResult((CoreQueryResult)response, this.serializer())));
    }
}

