/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.internal.repository.SdkAddonSource;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.SdkSourceCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SdkSources {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String SRC_FILENAME = "repositories.cfg";
    private final EnumMap<SdkSourceCategory, ArrayList<SdkSource>> mSources = new EnumMap(SdkSourceCategory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SdkSourceCategory sdkSourceCategory, SdkSource sdkSource) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> arrayList = this.mSources.get(sdkSourceCategory);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mSources.put(sdkSourceCategory, arrayList);
            }
            arrayList.add(sdkSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SdkSource sdkSource) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            Iterator<Map.Entry<SdkSourceCategory, ArrayList<SdkSource>>> iterator = this.mSources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry = iterator.next();
                ArrayList<SdkSource> arrayList = entry.getValue();
                if (!arrayList.remove(sdkSource) || !arrayList.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(SdkSourceCategory sdkSourceCategory) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            this.mSources.remove(sdkSourceCategory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSourceCategory[] getCategories() {
        ArrayList<SdkSourceCategory> arrayList = new ArrayList<SdkSourceCategory>();
        for (SdkSourceCategory sdkSourceCategory : SdkSourceCategory.values()) {
            if (sdkSourceCategory.getAlwaysDisplay()) {
                arrayList.add(sdkSourceCategory);
                continue;
            }
            EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
            synchronized (enumMap) {
                ArrayList<SdkSource> arrayList2 = this.mSources.get(sdkSourceCategory);
                if (arrayList2 != null && !arrayList2.isEmpty()) {
                    arrayList.add(sdkSourceCategory);
                }
            }
        }
        return arrayList.toArray(new SdkSourceCategory[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getSources(SdkSourceCategory sdkSourceCategory) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> arrayList = this.mSources.get(sdkSourceCategory);
            if (arrayList == null) {
                return new SdkSource[0];
            }
            return arrayList.toArray(new SdkSource[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getAllSources() {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            int n = 0;
            for (ArrayList<SdkSource> arrayList : this.mSources.values()) {
                n += arrayList.size();
            }
            SdkSource[] sdkSourceArray = new SdkSource[n];
            int n2 = 0;
            for (ArrayList<SdkSource> arrayList : this.mSources.values()) {
                for (SdkSource sdkSource : arrayList) {
                    sdkSourceArray[n2++] = sdkSource;
                }
            }
            return sdkSourceArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllPackages() {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            for (ArrayList<SdkSource> arrayList : this.mSources.values()) {
                for (SdkSource sdkSource : arrayList) {
                    sdkSource.clearPackages();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSourceCategory getCategory(SdkSource sdkSource) {
        if (sdkSource != null) {
            EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
            synchronized (enumMap) {
                for (Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry : this.mSources.entrySet()) {
                    if (!entry.getValue().contains(sdkSource)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSourceUrl(SdkSource sdkSource) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            for (ArrayList<SdkSource> arrayList : this.mSources.values()) {
                for (SdkSource sdkSource2 : arrayList) {
                    if (!sdkSource2.equals(sdkSource)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSourceUrl(SdkSourceCategory sdkSourceCategory, SdkSource sdkSource) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> arrayList = this.mSources.get(sdkSourceCategory);
            if (arrayList != null) {
                for (SdkSource sdkSource2 : arrayList) {
                    if (!sdkSource2.equals(sdkSource)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserAddons(ISdkLog iSdkLog) {
        this.removeAll(SdkSourceCategory.USER_ADDONS);
        FileInputStream fileInputStream = null;
        try {
            String string = AndroidLocation.getFolder();
            File file = new File(string, SRC_FILENAME);
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                int n = Integer.parseInt(properties.getProperty(KEY_COUNT, "0"));
                for (int i = 0; i < n; ++i) {
                    SdkAddonSource sdkAddonSource;
                    String string2 = properties.getProperty(String.format("%s%02d", KEY_SRC, i));
                    if (string2 == null || this.hasSourceUrl(sdkAddonSource = new SdkAddonSource(string2, null))) continue;
                    this.add(SdkSourceCategory.USER_ADDONS, sdkAddonSource);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            iSdkLog.error(numberFormatException, null, new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            iSdkLog.error(androidLocationException, null, new Object[0]);
        }
        catch (IOException iOException) {
            iSdkLog.error(iOException, null, new Object[0]);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAddons(ISdkLog iSdkLog) {
        FileOutputStream fileOutputStream = null;
        try {
            String string = AndroidLocation.getFolder();
            File file = new File(string, SRC_FILENAME);
            fileOutputStream = new FileOutputStream(file);
            Properties properties = new Properties();
            int n = 0;
            for (SdkSource sdkSource : this.getSources(SdkSourceCategory.USER_ADDONS)) {
                properties.setProperty(String.format("%s%02d", KEY_SRC, n), sdkSource.getUrl());
                ++n;
            }
            properties.setProperty(KEY_COUNT, Integer.toString(n));
            properties.store(fileOutputStream, "## User Sources for Android tool");
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            iSdkLog.error(androidLocationException, null, new Object[0]);
        }
        catch (IOException iOException) {
            iSdkLog.error(iOException, null, new Object[0]);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

