/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ResourceFileManager;
import com.crashlytics.tools.android.project.ResourceManager;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public abstract class AbstractAndroidProject
implements AndroidProject {
    private static final String DEOBS_SUBDIR = "deobs";
    protected final File _dataPath;
    protected final File _deobsPath;
    protected final ManifestData _manifestData;
    protected final File _manifestFile;
    protected final ResourceManager _resourceManager;
    protected final File _rootPath;
    protected static final FilenameFilter DEOBS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".zip");
        }
    };

    public AbstractAndroidProject(AndroidProjectStructure projStructure) throws IOException {
        this(projStructure.getProjectRootDir(), projStructure.getManifestFile(), projStructure.getProjectDataPath(), new ResourceFileManager(projStructure.getResourceDir()));
    }

    public AbstractAndroidProject(File projectPath, File manifestFile, File projectDataPath, ResourceManager manager) throws IOException {
        if (!projectPath.exists() || !projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        this._manifestFile = manifestFile;
        this._manifestData = DefaultManifestData.createManifest(this._manifestFile);
        this._resourceManager = manager;
        this._dataPath = projectDataPath;
        this._deobsPath = new File(projectDataPath, DEOBS_SUBDIR);
        this._rootPath = projectPath;
    }

    protected synchronized void createDataDir() throws IOException {
        FileUtils.verifyDirectory(this._dataPath);
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public ManifestData getManifestData() {
        return this._manifestData;
    }

    @Override
    public File getLauncherIcon() {
        return this._manifestData.getLauncherIcon();
    }

    @Override
    public UUID updateBuildId() throws IOException {
        if (!this._resourceManager.fileExists()) {
            this._resourceManager.createEmptyResourceFile();
        }
        UUID id = this._resourceManager.updateBuildId();
        return id;
    }

    @Override
    public UUID getBuildId() throws IOException {
        return this._resourceManager.getBuildId();
    }

    @Override
    public File getDataDirectory() {
        return this._dataPath;
    }

    @Override
    public void removeBuildResource() {
        this._resourceManager.removeBuildResource();
    }

    @Override
    public File getResourceFile() {
        return this._resourceManager.getResourceFile();
    }

    @Override
    public File getRootPath() {
        return this._rootPath;
    }

    @Override
    public String getApiKey() {
        return this.getManifestData().getMetaData().get("com.crashlytics.ApiKey");
    }

    @Override
    public abstract void storeDeobfuscationFile(File var1, String var2, String var3) throws IOException;

    @Override
    public abstract boolean hasCachedDeobfuscationFiles();

    @Override
    public abstract List<File> getDeobfuscationFiles() throws IOException;
}

