/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.android.sdklib.xml.AndroidManifestParser;
import com.android.sdklib.xml.ManifestData;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.ManifestData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultManifestData
implements ManifestData {
    private static final String XMLTAG_VERSION_NAME = "android:versionName";
    private static final String XMLTAG_ICON = "android:icon";
    private static final String PNG_EXTENSION = ".png";
    private final File _resDir;
    private final String _versionName;
    private final Set<String> _services;
    private final Set<String> _usesPermissions;
    private final Hashtable<String, String> _metaData;
    private final String _packageName;
    private final Integer _versionCodeOrNull;
    private final String _launcherActivityName;
    private String _iconName = null;
    private String _applicationClass = null;
    private static final FilenameFilter DRAWABLE_FOLDER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("drawable") && new File(dir, name).isDirectory();
        }
    };
    private static final FilenameFilter PNG_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(DefaultManifestData.PNG_EXTENSION);
        }
    };

    public static DefaultManifestData createManifest(final File manifestFile) throws ManifestData.ManifestIOException {
        return DefaultManifestData.createManifest(new ManifestProvider(){

            @Override
            public InputStream getManifestStream() throws ManifestData.ManifestIOException {
                try {
                    return new FileInputStream(manifestFile);
                }
                catch (FileNotFoundException e) {
                    throw new ManifestData.ManifestIOException("Crashlytics could not find the manifest. Not found at " + manifestFile.getAbsolutePath());
                }
            }

            @Override
            public File getManifestFile() {
                return manifestFile;
            }
        });
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider) throws ManifestData.ManifestIOException {
        File manifestFile = manifestProvider.getManifestFile();
        File resDir = new File(manifestFile.getParentFile(), "res");
        return DefaultManifestData.createManifest(manifestProvider, manifestFile.getAbsolutePath(), resDir);
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider, String manifestPathOnDisk, File resDir) throws ManifestData.ManifestIOException {
        String versionName;
        com.android.sdklib.xml.ManifestData data;
        HashSet<String> services = new HashSet<String>();
        HashSet<String> usesPermissions = new HashSet<String>();
        Hashtable<String, String> metaData = new Hashtable<String, String>();
        String iconName = null;
        String applicationClass = null;
        InputStream inputStream = manifestProvider.getManifestStream();
        try {
            data = AndroidManifestParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse " + manifestPathOnDisk + " as an Android manifest.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        inputStream = manifestProvider.getManifestStream();
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element manifestRoot = doc.getDocumentElement();
            versionName = manifestRoot.getAttribute(XMLTAG_VERSION_NAME);
            services.clear();
            NodeList appNodes = manifestRoot.getElementsByTagName("application");
            if (appNodes.getLength() != 0) {
                Element applicationEl = (Element)appNodes.item(0);
                if (applicationEl.hasAttribute(XMLTAG_ICON)) {
                    iconName = applicationEl.getAttribute(XMLTAG_ICON).replaceFirst("@drawable/", "");
                }
                if (applicationEl.hasAttribute("android:name") && (applicationClass = applicationEl.getAttribute("android:name")).startsWith(".")) {
                    applicationClass = data.getPackage() + applicationClass;
                }
                NodeList serviceNodes = applicationEl.getElementsByTagName("service");
                for (int i = 0; i < serviceNodes.getLength(); ++i) {
                    String serviceName = ((Element)serviceNodes.item(i)).getAttribute("name");
                    if (serviceName == null) continue;
                    services.add(serviceName);
                }
                NodeList metaDataNodes = applicationEl.getElementsByTagName("meta-data");
                for (int i = 0; i < metaDataNodes.getLength(); ++i) {
                    Element e = (Element)metaDataNodes.item(i);
                    String name = e.getAttribute("android:name");
                    String value = e.getAttribute("android:value");
                    metaData.put(name, value);
                }
                NodeList usesPermissionNodes = manifestRoot.getElementsByTagName("uses-permission");
                for (int i = 0; i < usesPermissionNodes.getLength(); ++i) {
                    Element e = (Element)usesPermissionNodes.item(i);
                    String permission = e.getAttribute("android:name");
                    usesPermissions.add(permission);
                }
            }
        }
        catch (Exception e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse the manifest found at " + manifestPathOnDisk, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        if (data.getPackage() == null) {
            DeveloperTools.logD("Crashlytics could not find a package name. This will likely cause issues during upload deobs files.");
        }
        String packageName = data.getPackage();
        Integer versionCode = data.getVersionCode();
        ManifestData.Activity launcherActivity = data.getLauncherActivity();
        String launcherActivityName = launcherActivity == null ? null : launcherActivity.getName();
        return new DefaultManifestData(resDir, versionName, services, usesPermissions, metaData, iconName, applicationClass, packageName, versionCode, launcherActivityName);
    }

    public DefaultManifestData(File resDir, String versionName, Set<String> services, Set<String> usesPermissions, Hashtable<String, String> metaData, String iconName, String applicationClass, String packageName, Integer versionCodeOrNull, String launcherActivityName) {
        this._resDir = resDir;
        this._versionName = versionName;
        this._services = services;
        this._usesPermissions = usesPermissions;
        this._metaData = metaData;
        this._iconName = iconName;
        this._applicationClass = applicationClass;
        this._packageName = packageName;
        this._versionCodeOrNull = versionCodeOrNull;
        this._launcherActivityName = launcherActivityName;
    }

    protected DefaultManifestData() {
        this._resDir = null;
        this._versionName = null;
        this._services = null;
        this._usesPermissions = null;
        this._metaData = null;
        this._iconName = null;
        this._applicationClass = null;
        this._packageName = null;
        this._versionCodeOrNull = null;
        this._launcherActivityName = null;
    }

    @Override
    public File getLauncherIcon() {
        if (this._iconName == null || !this._resDir.exists()) {
            return null;
        }
        int iconNameLength = this._iconName.length() + PNG_EXTENSION.length();
        for (File drawableDir : this._resDir.listFiles(DRAWABLE_FOLDER_FILTER)) {
            for (String drawable : drawableDir.list(PNG_FILE_FILTER)) {
                if (drawable.length() != iconNameLength || !drawable.startsWith(this._iconName)) continue;
                return new File(drawableDir.getAbsoluteFile(), drawable);
            }
        }
        return null;
    }

    @Override
    public String getPackage() {
        return this._packageName;
    }

    @Override
    public Integer getVersionCodeOrNull() {
        return this._versionCodeOrNull;
    }

    @Override
    public String getVersionName() {
        return this._versionName;
    }

    @Override
    public boolean declaresService(String serviceName) {
        return this._services.contains(serviceName);
    }

    @Override
    public String getMainActivity() {
        return this._launcherActivityName;
    }

    @Override
    public String getApplicationClass() {
        return this._applicationClass;
    }

    @Override
    public Hashtable<String, String> getMetaData() {
        return this._metaData;
    }

    @Override
    public boolean usesPermission(String permission) {
        return this._usesPermissions.contains(permission);
    }

    public static interface ManifestProvider {
        public InputStream getManifestStream() throws ManifestData.ManifestIOException;

        public File getManifestFile() throws ManifestData.ManifestIOException;
    }
}

