/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.ResourceHelper;
import com.crashlytics.tools.android.project.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ResourceFileManager
implements ResourceManager {
    private final DocumentBuilder _docBuilder;
    private final File _resourceFile;

    public ResourceFileManager(File resDir) {
        if (!resDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid resource path: " + resDir.getAbsolutePath());
        }
        File valuesPath = new File(resDir, "values");
        this._resourceFile = new File(valuesPath, "com_crashlytics_export_strings.xml");
        try {
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean fileExists() {
        return this._resourceFile.exists() && this._resourceFile.isFile();
    }

    @Override
    public void createEmptyResourceFile() throws IOException {
        File parentDir = this._resourceFile.getParentFile();
        if (parentDir.exists() && !parentDir.isDirectory()) {
            throw new IOException("Could not create resource file, path is not a directory: " + parentDir);
        }
        if (!parentDir.exists() && !parentDir.mkdir()) {
            throw new IOException("Could not create resource directory: " + parentDir);
        }
        ResourceHelper.writeInputStreamToFile(ResourceHelper.createEmptyResourceFileStream(), this._resourceFile);
    }

    @Override
    public void removeBuildResource() {
        this._resourceFile.delete();
    }

    @Override
    public UUID updateBuildId() {
        UUID toReturn = UUID.randomUUID();
        try {
            InputStream is = this.updateBuildId(new FileInputStream(this._resourceFile), toReturn.toString());
            ResourceHelper.writeInputStreamToFile(is, this._resourceFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Crashlytics could not create: " + this._resourceFile, e);
        }
        return toReturn;
    }

    public InputStream updateBuildId(InputStream source, String newId) throws SAXException, IOException {
        Document doc = this._docBuilder.parse(source);
        Element buildIdElement = ResourceHelper.getBuildIdElement(doc);
        if (buildIdElement == null) {
            buildIdElement = doc.createElement("string");
            buildIdElement.setAttribute("name", "com.crashlytics.android.build_id");
            Node resources = doc.getFirstChild();
            resources.appendChild(buildIdElement);
        }
        buildIdElement.setTextContent(newId);
        ByteArrayInputStream toReturn = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource newSource = new DOMSource(doc);
            transformer.transform(newSource, result);
            toReturn = new ByteArrayInputStream(result.getWriter().toString().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    @Override
    public UUID getBuildId() throws IOException {
        if (!this._resourceFile.exists()) {
            return null;
        }
        UUID toReturn = null;
        try {
            Document doc = this._docBuilder.parse(this._resourceFile);
            Element buildIdElement = ResourceHelper.getBuildIdElement(doc);
            if (buildIdElement != null) {
                toReturn = UUID.fromString(buildIdElement.getTextContent());
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return toReturn;
    }

    @Override
    public File getResourceFile() {
        return this._resourceFile;
    }
}

