/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.abx;

import com.crashlytics.tools.utils.abx.AbxStringPoolEntry;
import com.crashlytics.tools.utils.abx.AbxUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringResourcesMap {
    private LinkedHashMap<String, AbxStringPoolEntry> _map = new LinkedHashMap();

    public String findStringValueByResId(int id) {
        int index = AbxUtils.entryIndexFromResId(id);
        for (Map.Entry<String, AbxStringPoolEntry> e : this._map.entrySet()) {
            if (index-- != 0) continue;
            return e.getValue().getValue();
        }
        return null;
    }

    public String getStringValue(String key) {
        AbxStringPoolEntry value = this._map.get(key);
        return value == null ? null : value.getValue();
    }

    public String toString() {
        String toReturn = "StringResourcesMap {";
        Iterator<Map.Entry<String, AbxStringPoolEntry>> i = this._map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, AbxStringPoolEntry> e = i.next();
            toReturn = toReturn + e.toString();
            if (!i.hasNext()) continue;
            toReturn = toReturn + ", ";
        }
        toReturn = toReturn + "}";
        return toReturn;
    }

    public void put(String key, AbxStringPoolEntry value) {
        this._map.put(key, value);
    }
}

