/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.io;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.io.IFileOp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class FileOp
implements IFileOp {
    private static Method sFileSetExecutable = null;
    private static final Object[] sFileSetExecutableParams = new Object[]{Boolean.TRUE, Boolean.FALSE};

    public static File append(File file, String ... stringArray) {
        for (String string : stringArray) {
            file = new File(file, string);
        }
        return file;
    }

    public static File append(String string, String ... stringArray) {
        return FileOp.append(new File(string), stringArray);
    }

    public void deleteFileOrFolder(File file) {
        if (file != null) {
            File[] fileArray;
            if (this.isDirectory(file) && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    this.deleteFileOrFolder(file2);
                }
            }
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                for (int i = 0; i < 5; ++i) {
                    if (file.delete()) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                file.deleteOnExit();
            } else if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public void setExecutablePermission(File file) throws IOException {
        if (sFileSetExecutable != null) {
            try {
                sFileSetExecutable.invoke((Object)file, sFileSetExecutableParams);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().exec(new String[]{"chmod", "+x", file.getAbsolutePath()});
    }

    public void setReadOnly(File file) {
        file.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameFile(File file, File file2) throws IOException {
        if (file.length() != file2.length()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            boolean bl;
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file2);
            byte[] byArray = new byte[8192];
            byte[] byArray2 = new byte[8192];
            do {
                int n;
                if ((n = fileInputStream.read(byArray)) == -1) return true;
                int n2 = 0;
                while (n2 < n && !(bl = fileInputStream2.read(byArray2, n2, n - n2))) {
                }
                if (n2 == n) continue;
                bl = false;
                return bl;
            } while (Arrays.equals(byArray, byArray2));
            bl = false;
            return bl;
        }
        finally {
            if (fileInputStream2 != null) {
                try {
                    fileInputStream2.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isFile(File file) {
        return file.isFile();
    }

    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public boolean exists(File file) {
        return file.exists();
    }

    public long length(File file) {
        return file.length();
    }

    public boolean delete(File file) {
        return file.delete();
    }

    public boolean mkdirs(File file) {
        return file.mkdirs();
    }

    public File[] listFiles(File file) {
        return file.listFiles();
    }

    public boolean renameTo(File file, File file2) {
        return file.renameTo(file2);
    }

    public OutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    static {
        try {
            sFileSetExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

