/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import org.json.simple.JSONObject;

public class Organization {
    private final String _id;
    private final String _alias;
    private final String _name;
    private final String _apiKey;
    private int _appCount;
    private final String _buildSecret;

    public Organization(String id, String alias, String name, String apiKey, int appCount, String buildSecret) {
        if (alias.isEmpty() || name.isEmpty() || apiKey.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty parameter: " + alias + ", " + name + ", " + apiKey);
        }
        this._id = id;
        this._alias = alias;
        this._name = name;
        this._apiKey = apiKey;
        this._appCount = appCount;
        this._buildSecret = buildSecret;
    }

    public Organization(JSONObject json) {
        this((String)json.get("id"), (String)json.get("alias"), (String)json.get("name"), (String)json.get("api_key"), 0, (String)json.get("build_secret"));
        int count = 0;
        JSONObject appsCounts = (JSONObject)json.get("apps_counts");
        for (Object obj : appsCounts.values()) {
            count += ((Number)obj).intValue();
        }
        this._appCount = count;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getName() {
        return this._name;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public int getAppCount() {
        return this._appCount;
    }

    public String getId() {
        return this._id;
    }

    public String getBuildSecret() {
        return this._buildSecret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._alias == null ? 0 : this._alias.hashCode());
        result = 31 * result + (this._apiKey == null ? 0 : this._apiKey.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Organization other = (Organization)obj;
        return this._alias.equals(other._alias) && this._apiKey.equals(other._apiKey) && this._name.equals(other._name);
    }

    public String toString() {
        return this._name;
    }
}

