/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceHelper {
    public static InputStream createEmptyResourceFileStream() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<resources>\n");
        sb.append("<!--\n");
        sb.append("  This file is automatically generated by Crashlytics to uniquely \n");
        sb.append("  identify individual builds of your Android application.\n");
        sb.append("\n");
        sb.append("  Do NOT modify, delete, or commit to source control!\n");
        sb.append("-->\n");
        sb.append("</resources>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public static Element getBuildIdElement(Document doc) {
        NodeList strings = doc.getElementsByTagName("string");
        Element buildIdElement = null;
        for (int i = 0; i < strings.getLength(); ++i) {
            Element el = (Element)strings.item(i);
            if (!el.hasAttribute("name") || !el.getAttribute("name").equals("com.crashlytics.android.build_id")) continue;
            buildIdElement = el;
            break;
        }
        return buildIdElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToFile(InputStream source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(source));
            writer = new PrintWriter(dest);
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

