/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.abx;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class PositionInputStream
extends FilterInputStream {
    private long pos = 0L;
    private long mark = 0L;

    public PositionInputStream(InputStream in) {
        super(in);
    }

    public synchronized long getPosition() {
        return this.pos;
    }

    @Override
    public synchronized int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            ++this.pos;
        }
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    @Override
    public synchronized long skip(long skip) throws IOException {
        long n = super.skip(skip);
        if (n > 0L) {
            this.pos += n;
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("Mark not supported.");
        }
        super.reset();
        this.pos = this.mark;
    }
}

