/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.Organization;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class BuildSecretMaintainer {
    private String _buildSecret;
    private final File _propertiesPath;
    private WebApi _api;
    private String _apiKey;

    public BuildSecretMaintainer(WebApi api, String apiKey, String buildSecret, File propertiesPath) {
        this._api = api;
        this._apiKey = apiKey;
        this._buildSecret = buildSecret;
        this._propertiesPath = propertiesPath;
    }

    public void maintainBuildSecret() throws IOException {
        try {
            Organization org;
            if (this._api != null && (org = this._api.getOrg(this._apiKey)) != null && org.getBuildSecret() != null) {
                this._buildSecret = org.getBuildSecret();
            }
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        if (this._buildSecret != null && this._propertiesPath != null) {
            if (!this._propertiesPath.exists()) {
                this._propertiesPath.createNewFile();
            }
            try {
                Properties props = new Properties();
                props.put("apiSecret", this._buildSecret);
                PropertiesUtils.injectPropertyInFile(this._propertiesPath, props, "Contains API Secret used to validate your application. Commit to internal source control; avoid making secret public.");
            }
            catch (IOException io) {
                DeveloperTools.logD("Crashlytics was unable to inject property into file: " + this._propertiesPath);
            }
        }
    }

    public String getBuildSecret() {
        return this._buildSecret;
    }
}

