/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestFileProvider;
import com.crashlytics.tools.android.project.StandardAndroidProject;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class StandardAndroidProjectFactory {
    public AndroidProject create(Properties properties) throws IOException {
        File projectPath = new File(properties.getProperty("projectPath", "."));
        File manifestPath = properties.containsKey("androidManifest") ? new File(properties.getProperty("androidManifest")) : new File(projectPath, "AndroidManifest.xml");
        File resPath = properties.containsKey("androidRes") ? new File(properties.getProperty("androidRes")) : new File(projectPath, "res");
        File assetsPath = properties.containsKey("androidAssets") ? new File(properties.getProperty("androidAssets")) : new File(projectPath, "assets");
        File propertiesFile = StandardAndroidProject.getPropertiesLoc(projectPath);
        if (properties.containsKey("properties")) {
            propertiesFile = new File(properties.getProperty("properties"));
        }
        AndroidProjectStructure structure = new AndroidProjectStructure(projectPath, manifestPath, resPath, assetsPath, StandardAndroidProject.getDataDirectory(projectPath), propertiesFile);
        AndroidProject project = this.create(structure, properties);
        return project;
    }

    public AndroidProject create(AndroidProjectStructure structure) throws IOException {
        return this.createTypedProject(structure, "STANDARD_PROJECT");
    }

    public AndroidProject create(AndroidProjectStructure structure, Properties properties) throws IOException {
        return this.createTypedProject(structure, properties, "STANDARD_PROJECT");
    }

    protected AndroidProject createTypedProject(AndroidProjectStructure structure, String projectType) throws IOException {
        Properties properties;
        try {
            properties = PropertiesUtils.read(structure.getPropertyFile());
        }
        catch (IOException e) {
            properties = new Properties();
        }
        return this.createTypedProject(structure, properties, projectType);
    }

    protected StandardAndroidProject createTypedProject(AndroidProjectStructure structure, Properties properties, String projectType) throws IOException {
        String appName;
        File projectPath = structure.getProjectRootDir();
        if (!projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        File manifestFile = structure.getManifestFile();
        File dataPath = structure.getProjectDataPath();
        File resDir = structure.getResourceDir();
        File assetsDir = structure.getAssetsDir();
        File resourceFile = StandardAndroidProject.getStringResourceLoc(resDir);
        DefaultManifestData manifestData = DefaultManifestData.createManifest(new ManifestFileProvider(structure.getManifestFile()), resDir);
        if (!projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        String apiKey = manifestData.getApiKey();
        if (apiKey == null) {
            apiKey = properties.getProperty("apiKey");
        }
        String buildSecret = properties.getProperty("apiSecret");
        String packageName = properties.getProperty("renamedPackage");
        if (packageName == null || packageName.isEmpty()) {
            packageName = manifestData.getPackageName();
        }
        if ((appName = manifestData.getApplicationName()) == null) {
            appName = packageName;
        }
        File launcherIcon = manifestData.getLauncherIcon();
        boolean betaDistEnabled = Boolean.parseBoolean(properties.getProperty("betaDistributionEnabled"));
        return new StandardAndroidProject(projectPath, manifestFile, dataPath, structure.getPropertyFile(), resourceFile, assetsDir, manifestData, projectType, buildSecret, apiKey, packageName, appName, launcherIcon, betaDistEnabled);
    }
}

