/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.net.proxy;

import com.crashlytics.api.net.proxy.ProtocolScheme;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;

public class ProxySettings {
    private final String _proxyHost;
    private final Integer _proxyPort;
    private final String _proxyUser;
    private final String _proxyPassword;

    public ProxySettings(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._proxyUser = proxyUser;
        this._proxyPassword = proxyPassword;
    }

    public static ProxySettings create(ProtocolScheme scheme) throws IOException {
        String proxyHost = scheme.getHost();
        String proxyUser = scheme.getUser();
        String proxyPassword = scheme.getPassword();
        String proxyPortString = scheme.getPort();
        Integer proxyPort = null;
        if (proxyPortString != null) {
            try {
                proxyPort = Integer.parseInt(proxyPortString);
            }
            catch (NumberFormatException e) {
                throw new IOException("Crashlytics could not read proxy port string.");
            }
        }
        return new ProxySettings(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public RequestConfig getConfig() {
        if (this._proxyHost == null || this._proxyPort == null) {
            return RequestConfig.DEFAULT;
        }
        DeveloperTools.logD("Crashlytics using custom proxy settings: " + this._proxyHost + ":" + this._proxyPort);
        HttpHost proxy = new HttpHost(this._proxyHost, (int)this._proxyPort);
        return RequestConfig.custom().setProxy(proxy).build();
    }

    public HttpClient getClientFor() throws IOException {
        if (this._proxyHost == null || this._proxyPort == null || this._proxyUser == null || this._proxyPassword == null) {
            return HttpClients.createDefault();
        }
        DeveloperTools.logD("Crashlytics using proxy auth:" + this._proxyUser);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this._proxyUser, this._proxyPassword);
        AuthScope authScope = new AuthScope(this._proxyHost, this._proxyPort);
        credsProvider.setCredentials(authScope, credentials);
        return HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
    }
}

