/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.ModuleClass;
import com.crashlytics.tools.utils.GradleUtils;

public class Module {
    private final String _groupId;
    private final String _artifactId;
    private final String _version;
    private final ModuleClass _moduleClass;
    private final boolean _isAar;

    public Module(String groupId, String artifactId, String version, ModuleClass moduleClass) {
        this(groupId, artifactId, version, moduleClass, false);
    }

    public Module(String groupId, String artifactId, String version, ModuleClass moduleClass, boolean isAar) {
        this._groupId = groupId;
        this._artifactId = artifactId;
        this._version = version;
        this._moduleClass = moduleClass;
        this._isAar = isAar;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getVersion() {
        return this._version;
    }

    public ModuleClass getModuleClass() {
        return this._moduleClass;
    }

    public String getGradleDependencyString(String lineSeparator) {
        if (this._isAar) {
            return "compile('" + this._groupId + ":" + this._artifactId + ":" + this._version + "@aar') {" + lineSeparator + GradleUtils.getTabs(1) + "transitive = true;" + lineSeparator + "}";
        }
        return "compile '" + this._groupId + ":" + this._artifactId + ":" + this._version + "'";
    }

    public boolean isSameArtifact(Module other) {
        return this.getArtifactId().equals(other.getArtifactId()) && this.getGroupId().equals(other.getGroupId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Module)) {
            return false;
        }
        Module module = (Module)o;
        return this._artifactId.equals(module._artifactId) && this._groupId.equals(module._groupId) && this._version.equals(module._version);
    }

    public int hashCode() {
        int result = this._groupId.hashCode();
        result = 31 * result + this._artifactId.hashCode();
        result = 31 * result + this._version.hashCode();
        return result;
    }
}

