/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.Module;
import com.crashlytics.tools.android.onboard.ModuleClass;
import com.crashlytics.tools.android.onboard.Repository;
import java.util.Arrays;
import java.util.List;

public class OnboardingConstants {
    public static final String TWITTERSDK_REPOSITORY_USER_PROPERTY = "TWITTERSDK_REPOSITORY_USER";
    public static final String TWITTERSDK_REPOSITORY_PASSWORD_PROPERTY = "TWITTERSDK_REPOSITORY_PASSWORD";
    public static final String TWITTERSDK_REPOSITORY_URL_PROPERTY = "TWITTERSDK_REPOSITORY_URL";
    public static final String TWITTER_SDK_REPOSITORY = "https://android-sdk.crashlytics.com/twittersdk/repo";
    public static final Repository TMP_TWITTER_REPOSITORY = Repository.createAuthenticatedRepository("https://android-sdk.crashlytics.com/twittersdk/repo", "username", "password");
    public static final Repository TWITTER_REPOSITORY_WITH_PROPERTIES = Repository.createAuthenticatedRepository("TWITTERSDK_REPOSITORY_URL", "TWITTERSDK_REPOSITORY_USER", "TWITTERSDK_REPOSITORY_PASSWORD");
    public static final String SDK_PACKAGE = "com.twitter.sdk.android";
    public static final String CRASHLYTICS_PACKAGE = "com.crashlytics.android";
    public static final String CRASHLYTICS_FULLY_QUALIFIED = "com.crashlytics.android.Crashlytics";
    private static final ModuleClass CRASHLYTICS_CLASS = new ModuleClass("com.crashlytics.android.Crashlytics", "Crashlytics");
    private static final ModuleClass TWITTER_IDENTITY_CLASS = new ModuleClass("com.twitter.sdk.android.identity.TwitterIdentity", "TwitterIdentity");
    private static final ModuleClass TWITTER_SOCIAL_CLASS = new ModuleClass("com.twitter.sdk.android.twittersocial.TwitterSocial", "TwitterSocial");
    public static final Module CRASHLYTICS_MODULE = new Module("com.crashlytics.android", "crashlytics", "1.+", CRASHLYTICS_CLASS);
    private static final String TWITTER_SDK_GROUP_ID = "com.twitter.sdk.android";
    public static final Module CRASHLYTICS_KIT = new Module("com.twitter.sdk.android", "crashlytics", "+", CRASHLYTICS_CLASS, true);
    public static final Module TWITTER_IDENTITY_KIT = new Module("com.twitter.sdk.android", "twitteridentity", "+", TWITTER_IDENTITY_CLASS, true);
    public static final Module TWITTER_SOCIAL_KIT = new Module("com.twitter.sdk.android", "twittersocial", "+", TWITTER_SOCIAL_CLASS, true);
    public static final List<Module> DEFAULT_MODULES = Arrays.asList(CRASHLYTICS_KIT, TWITTER_IDENTITY_KIT, TWITTER_SOCIAL_KIT);
    public static final Repository BUILDSCRIPT_REPOSITORY;
    public static final String BUILDSCRIPT_DEPENDENCY = "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'";
    public static final String APPLY_CRASHLYTICS = "apply plugin: 'crashlytics'";
    public static final Repository CRASHLYTICS_REPOSITORY;
    public static final String EXAMPLE_SRC_PATH = "examples/";
    public static final String EXAMPLE_MANIFEST_TITLE = "AndroidManifest.xml";
    public static final String BUILD_GRADLE_TITLE = "build.gradle";
    public static final String EXAMPLE_MANIFEST_FILE_NAME = "AndroidManifest.xml.txt";
    public static final String EXAMPLE_MANIFEST_FILE = "examples/AndroidManifest.xml.txt";
    public static final String JAVA_MAIN_ACTIVITY_NAME = "Start Activity";
    public static final String SRC_ACTIVITY = "MainActivity.java.txt";
    public static final String FILE_EXAMPLE_SRC_ACTIVITY = "examples/MainActivity.java.txt";
    public static final String BUILD_GRADLE_ACTIVITY = "build.gradle.txt";
    public static final String FILE_EXAMPLE_BUILD_GRADLE_ACTIVITY = "examples/build.gradle.txt";
    public static final String INTERNET_PERMISSION_XML = "<uses-permission android:name=\"android.permission.INTERNET\"/>";
    public static final String METADATA_ELEMENT_FORMAT = "<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>";
    public static final String GRADLE_PROPERTIES_TITLE = "gradle.properties";

    public static boolean isCrashlyticsModule(Module module) {
        return module != null && (module.isSameArtifact(CRASHLYTICS_MODULE) || module.isSameArtifact(CRASHLYTICS_KIT));
    }

    static {
        CRASHLYTICS_REPOSITORY = BUILDSCRIPT_REPOSITORY = Repository.createPublicRepository("http://download.crashlytics.com/maven");
    }
}

