/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.WebApi;
import com.crashlytics.api.ota.ReleaseNotes;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.base.Preconditions;
import com.crashlytics.reloc.com.google.common.base.Verify;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DistributionController {
    public static final int MAX_UPDATE_ACCESS_ENTRIES = 100;
    private final WebApi _webApi;
    private final String _apiKey;
    private final String _apiSecret;
    private final String _appPackageName;
    private final AppRelease _appRelease;
    private final List<String> _testerIds;
    private final List<String> _groupIds;
    private final List<String> _emails;
    private final int _maxUpdateAccessEntries;
    private final boolean _sendNotifications;
    private final Optional<File> _distributionFileOption;
    private final Optional<ReleaseNotes> _releaseNotesOption;
    private final Optional<ProgressIndicator> _progressIndicatorOption;
    private final WebApi.UploadProgressListener _uploadProgressListener = new WebApi.UploadProgressListener(){

        @Override
        public void bytesWritten(long totalSize, long bytesSent) {
            double progressFraction = (double)bytesSent / (double)totalSize;
            double fractionOfUploadPortion = progressFraction * (double)DistributionController.this.getUploadPortionProgressValue();
            int uploadProgress = (int)Math.ceil(fractionOfUploadPortion);
            DistributionController.this.setProgressValue(uploadProgress + (DistributionController.this.getMaxProgressValue() - DistributionController.this.getUploadPortionProgressValue()));
        }
    };

    private DistributionController(Builder builder) {
        this._webApi = builder.webApi;
        this._apiKey = builder.apiKey;
        this._apiSecret = builder.apiSecret;
        this._appRelease = builder.appRelease;
        this._appPackageName = this._appRelease.packageName;
        this._testerIds = new ArrayList<String>(builder.testerIds);
        this._groupIds = new ArrayList<String>(builder.groupIds);
        this._emails = new ArrayList<String>(builder.emails);
        this._maxUpdateAccessEntries = builder.maxUpdateAccessEntries;
        this._sendNotifications = builder.sendNotifications;
        this._distributionFileOption = Optional.fromNullable(builder.distributionFile);
        this._releaseNotesOption = Optional.fromNullable(builder.releaseNotes);
        this._progressIndicatorOption = Optional.fromNullable(builder.progressIndicator);
    }

    public boolean uploadDistribution() throws IOException, AuthenticationException {
        boolean success;
        int progressPortion = this._distributionFileOption.isPresent() ? this.getMaxProgressValue() - this.getUploadPortionProgressValue() : this.getMaxProgressValue();
        int preUploadSteps = this.calculatePreUploadSteps();
        int perStepProgress = (int)Math.ceil((double)progressPortion / (double)preUploadSteps);
        if (this._releaseNotesOption.isPresent()) {
            this.setProgressMessage("Updating release notes");
            success = this._webApi.getCurrentUser() == null ? this._webApi.setBuildServerReleaseNotes(this._apiKey, this._apiSecret, this._appPackageName, this._appRelease.instanceIdentifier, this._appRelease.displayVersion, this._appRelease.buildVersion, this._releaseNotesOption.get()) : this._webApi.setReleaseNotes(this._apiKey, this._appPackageName, this._appRelease.instanceIdentifier, this._appRelease.displayVersion, this._appRelease.buildVersion, this._releaseNotesOption.get());
            this.incrementProgressValue(perStepProgress);
        } else {
            success = true;
        }
        if (success) {
            success = this.updateAccessInBatches(perStepProgress);
        }
        if (success && this._distributionFileOption.isPresent()) {
            this.setProgressMessage("Uploading APK");
            if (this._appRelease == null) {
                throw new IllegalArgumentException("File is not an APK file with the Crashlytics SDK properly onboarded.");
            }
            DeveloperTools.logD("Uploading " + this._distributionFileOption.get().getAbsolutePath() + " with metadata: " + this._appRelease);
            DeveloperTools.logD("Instance identifier is: " + this._appRelease.instanceIdentifier);
            DistributionData distributionData = new DistributionData(this._distributionFileOption.get(), System.currentTimeMillis() / 1000L);
            success = this._webApi.createDistribution(this._apiKey, this._apiSecret, this._appRelease, distributionData, this._sendNotifications, this._uploadProgressListener);
            DeveloperTools.logD("Distribution upload success: " + success);
        }
        DeveloperTools.logD("Distribution success: " + success);
        return success;
    }

    private boolean updateAccessInBatches(int perStepProgress) throws IOException, AuthenticationException {
        boolean success = true;
        List<String> pendingEmails = this._emails;
        List<String> pendingTesterIds = this._testerIds;
        List<String> pendingGroupIds = this._groupIds;
        while (!(!success || pendingEmails.isEmpty() && pendingTesterIds.isEmpty() && pendingGroupIds.isEmpty())) {
            int entriesAvailable = this._maxUpdateAccessEntries;
            int emailsIndex = Math.min(pendingEmails.size(), entriesAvailable);
            List<String> emailsToSend = pendingEmails.subList(0, emailsIndex);
            pendingEmails = pendingEmails.subList(emailsToSend.size(), pendingEmails.size());
            int testerIdsIndex = Math.min(pendingTesterIds.size(), entriesAvailable -= emailsToSend.size());
            List<String> testerIdsToSend = pendingTesterIds.subList(0, testerIdsIndex);
            pendingTesterIds = pendingTesterIds.subList(testerIdsToSend.size(), pendingTesterIds.size());
            int groupIdsIndex = Math.min(pendingGroupIds.size(), entriesAvailable -= testerIdsToSend.size());
            List<String> groupIdsToSend = pendingGroupIds.subList(0, groupIdsIndex);
            pendingGroupIds = pendingGroupIds.subList(groupIdsToSend.size(), pendingGroupIds.size());
            success = this.updateAccess(emailsToSend, testerIdsToSend, groupIdsToSend, perStepProgress);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAccess(List<String> emails, List<String> testerIds, List<String> groupIds, int perStepProgress) throws IOException, AuthenticationException {
        boolean success;
        try {
            boolean sendNotifications;
            DeveloperTools.logD("Updating access for release: " + this._appRelease.appName + " with emails: " + emails + " testers: " + testerIds + " groups: " + groupIds);
            this.setProgressMessage("Updating release information");
            boolean bl = sendNotifications = !this._distributionFileOption.isPresent();
            success = this._webApi.getCurrentUser() == null ? this._webApi.updateBuildServerAccess(this._apiKey, this._apiSecret, this._appPackageName, this._appRelease.instanceIdentifier, this._appRelease.displayVersion, this._appRelease.buildVersion, emails, testerIds, groupIds, WebApi.AccessChange.ENABLE, sendNotifications) : this._webApi.updateAccess(this._apiKey, this._appPackageName, this._appRelease.instanceIdentifier, this._appRelease.displayVersion, this._appRelease.buildVersion, emails, testerIds, groupIds, WebApi.AccessChange.ENABLE, sendNotifications);
        }
        finally {
            this.incrementProgressValue(perStepProgress);
        }
        return success;
    }

    private int calculatePreUploadSteps() {
        double stepsFraction = (double)(this._emails.size() + this._testerIds.size() + this._groupIds.size()) / (double)this._maxUpdateAccessEntries;
        int steps = (int)Math.ceil(stepsFraction);
        return steps + (this._releaseNotesOption.isPresent() ? 1 : 0);
    }

    private void incrementProgressValue(int perStepProgress) {
        if (this._progressIndicatorOption.isPresent()) {
            this._progressIndicatorOption.get().incrementProgressValue(perStepProgress);
        }
    }

    private void setProgressMessage(String progressMessage) {
        if (this._progressIndicatorOption.isPresent()) {
            this._progressIndicatorOption.get().setProgressMessage(progressMessage);
        }
    }

    private int getMaxProgressValue() {
        if (this._progressIndicatorOption.isPresent()) {
            return this._progressIndicatorOption.get().getMaxProgressValue();
        }
        return 0;
    }

    private int getUploadPortionProgressValue() {
        if (this._progressIndicatorOption.isPresent()) {
            return this._progressIndicatorOption.get().getUploadPortionProgressValue();
        }
        return 0;
    }

    private void setProgressValue(int progressValue) {
        if (this._progressIndicatorOption.isPresent()) {
            this._progressIndicatorOption.get().setProgressValue(progressValue);
        }
    }

    public static class Builder {
        final WebApi webApi;
        final String apiKey;
        final String apiSecret;
        final AppRelease appRelease;
        List<String> testerIds = Collections.emptyList();
        List<String> groupIds = Collections.emptyList();
        List<String> emails = Collections.emptyList();
        int maxUpdateAccessEntries;
        boolean sendNotifications = true;
        File distributionFile;
        ReleaseNotes releaseNotes;
        ProgressIndicator progressIndicator;

        public Builder(WebApi webApi, String apiKey, String apiSecret, AppRelease appRelease, int maxUpdateAccessEntries) {
            this.webApi = Preconditions.checkNotNull(webApi);
            this.apiKey = Preconditions.checkNotNull(apiKey);
            this.apiSecret = Preconditions.checkNotNull(apiSecret);
            this.appRelease = Preconditions.checkNotNull(appRelease);
            this.maxUpdateAccessEntries = maxUpdateAccessEntries;
            Verify.verify(this.maxUpdateAccessEntries > 0, "maxUpdateAccessEntries must be > 0", new Object[0]);
        }

        public Builder setTesterIds(List<String> testerIds) {
            if (testerIds != null) {
                this.testerIds = testerIds;
            }
            return this;
        }

        public Builder setGroupIds(List<String> groupIds) {
            if (groupIds != null) {
                this.groupIds = groupIds;
            }
            return this;
        }

        public Builder setEmails(List<String> emails) {
            if (emails != null) {
                this.emails = emails;
            }
            return this;
        }

        public Builder setDistributionFile(File distributionFile) {
            this.distributionFile = distributionFile;
            return this;
        }

        public Builder setReleaseNotes(ReleaseNotes releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        public Builder setProgressIndicator(ProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
            return this;
        }

        public Builder setSendNotifications(boolean sendNotifications) {
            this.sendNotifications = sendNotifications;
            return this;
        }

        public DistributionController build() {
            return new DistributionController(this);
        }
    }

    public static interface ProgressIndicator {
        public int getMaxProgressValue();

        public int getUploadPortionProgressValue();

        public void setProgressMessage(String var1);

        public void setProgressValue(int var1);

        public void incrementProgressValue(int var1);
    }
}

