/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.storage.detail;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Header {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int CURRENT = 1;
    public final int version;
    public final int length;
    public final byte[] padding = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    private Header(int version, int length) {
        this.version = version;
        this.length = length;
    }

    public static Header from(byte[] bytes) {
        return new Header(ByteBuffer.wrap(bytes, 0, 4).getInt(), ByteBuffer.wrap(bytes, 4, 4).getInt());
    }

    public static Header get(int length) {
        return new Header(1, length);
    }

    public static Header get(String data) {
        return new Header(1, data.getBytes(UTF_8).length);
    }

    public static int size() {
        return 16;
    }

    public byte[] bytes() {
        return ByteBuffer.allocate(Header.size()).putInt(this.version).putInt(this.length).put(this.padding).array();
    }
}

