/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth;

import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth.AuthScheme;
import com.crashlytics.dependency.reloc.org.apache.commons.logging.Log;
import com.crashlytics.dependency.reloc.org.apache.commons.logging.LogFactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AuthPolicy {
    private static final HashMap SCHEMES = new HashMap();
    private static final ArrayList SCHEME_LIST = new ArrayList();
    public static final String AUTH_SCHEME_PRIORITY = "http.auth.scheme-priority";
    public static final String NTLM = "NTLM";
    public static final String DIGEST = "Digest";
    public static final String BASIC = "Basic";
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$NTLMScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$DigestScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$BasicScheme;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$AuthPolicy;

    public static synchronized void registerAuthScheme(String id, Class clazz) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Authentication scheme class may not be null");
        }
        SCHEMES.put(id.toLowerCase(), clazz);
        SCHEME_LIST.add(id.toLowerCase());
    }

    public static synchronized void unregisterAuthScheme(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SCHEMES.remove(id.toLowerCase());
        ((AbstractCollection)SCHEME_LIST).remove(id.toLowerCase());
    }

    public static synchronized AuthScheme getAuthScheme(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SCHEMES.get(id.toLowerCase());
        if (clazz != null) {
            try {
                return (AuthScheme)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error("Error initializing authentication scheme: " + id, e);
                throw new IllegalStateException(id + " authentication scheme implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported authentication scheme " + id);
    }

    public static synchronized List getDefaultAuthPrefs() {
        return (List)SCHEME_LIST.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AuthPolicy.registerAuthScheme(NTLM, class$org$apache$commons$httpclient$auth$NTLMScheme == null ? (class$org$apache$commons$httpclient$auth$NTLMScheme = AuthPolicy.class$("com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth.NTLMScheme")) : class$org$apache$commons$httpclient$auth$NTLMScheme);
        AuthPolicy.registerAuthScheme(DIGEST, class$org$apache$commons$httpclient$auth$DigestScheme == null ? (class$org$apache$commons$httpclient$auth$DigestScheme = AuthPolicy.class$("com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth.DigestScheme")) : class$org$apache$commons$httpclient$auth$DigestScheme);
        AuthPolicy.registerAuthScheme(BASIC, class$org$apache$commons$httpclient$auth$BasicScheme == null ? (class$org$apache$commons$httpclient$auth$BasicScheme = AuthPolicy.class$("com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth.BasicScheme")) : class$org$apache$commons$httpclient$auth$BasicScheme);
        LOG = LogFactory.getLog(class$org$apache$commons$httpclient$auth$AuthPolicy == null ? (class$org$apache$commons$httpclient$auth$AuthPolicy = AuthPolicy.class$("com.crashlytics.dependency.reloc.org.apache.commons.httpclient.auth.AuthPolicy")) : class$org$apache$commons$httpclient$auth$AuthPolicy);
    }
}

