/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.cache;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.cache.AbstractFilesCache;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final Map filesystemCache = new HashMap(10);

    public void putFile(FileObject file) {
        Map files = this.getOrCreateFilesystemCache(file.getFileSystem());
        files.put(file.getName(), file);
    }

    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        return (FileObject)files.get(name);
    }

    public void clear(FileSystem filesystem) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        files.clear();
    }

    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        TreeMap files = (TreeMap)this.filesystemCache.get(filesystem);
        if (files == null) {
            files = new TreeMap();
            this.filesystemCache.put(filesystem, files);
        }
        return files;
    }

    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    public void removeFile(FileSystem filesystem, FileName name) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        files.remove(name);
    }

    public void touchFile(FileObject file) {
    }
}

