/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.impl;

import com.crashlytics.dependency.reloc.org.apache.commons.logging.Log;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSelector;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.FileReplicator;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.VfsComponent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.VfsComponentContext;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PrivilegedFileReplicator
implements FileReplicator,
VfsComponent {
    private final FileReplicator replicator;
    private final VfsComponent replicatorComponent;

    public PrivilegedFileReplicator(FileReplicator replicator) {
        this.replicator = replicator;
        this.replicatorComponent = replicator instanceof VfsComponent ? (VfsComponent)((Object)replicator) : null;
    }

    public void setLogger(Log logger) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setLogger(logger);
        }
    }

    public void setContext(VfsComponentContext context) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setContext(context);
        }
    }

    public void init() throws FileSystemException {
        if (this.replicatorComponent != null) {
            try {
                AccessController.doPrivileged(new InitAction());
            }
            catch (PrivilegedActionException e) {
                throw new FileSystemException("vfs.impl/init-replicator.error", null, (Throwable)e);
            }
        }
    }

    public void close() {
        if (this.replicatorComponent != null) {
            AccessController.doPrivileged(new CloseAction());
        }
    }

    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        try {
            ReplicateAction action = new ReplicateAction(srcFile, selector);
            return (File)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw new FileSystemException("vfs.impl/replicate-file.error", new Object[]{srcFile.getName()}, (Throwable)e);
        }
    }

    private class CloseAction
    implements PrivilegedAction {
        private CloseAction() {
        }

        public Object run() {
            PrivilegedFileReplicator.this.replicatorComponent.close();
            return null;
        }
    }

    private class ReplicateAction
    implements PrivilegedExceptionAction {
        private final FileObject srcFile;
        private final FileSelector selector;

        public ReplicateAction(FileObject srcFile, FileSelector selector) {
            this.srcFile = srcFile;
            this.selector = selector;
        }

        public Object run() throws Exception {
            return PrivilegedFileReplicator.this.replicator.replicateFile(this.srcFile, this.selector);
        }
    }

    private class InitAction
    implements PrivilegedExceptionAction {
        private InitAction() {
        }

        public Object run() throws Exception {
            PrivilegedFileReplicator.this.replicatorComponent.init();
            return null;
        }
    }
}

