/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.UriParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.VfsComponentContext;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;

    public HostFileNameParser(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        Authority auth = this.extractToPath(filename, name);
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new GenericFileName(auth.scheme, auth.hostName, auth.port, this.defaultPort, auth.userName, auth.password, path, fileType);
    }

    protected Authority extractToPath(String uri, StringBuffer name) throws FileSystemException {
        String password;
        String userName;
        Authority auth = new Authority();
        auth.scheme = UriParser.extractScheme(uri, name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", uri);
        }
        name.delete(0, 2);
        String userInfo = this.extractUserInfo(name);
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                userName = userInfo;
                password = null;
            } else {
                userName = userInfo.substring(0, idx);
                password = userInfo.substring(idx + 1);
            }
        } else {
            userName = null;
            password = null;
        }
        auth.userName = UriParser.decode(userName);
        auth.password = UriParser.decode(password);
        String hostName = this.extractHostName(name);
        if (hostName == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", uri);
        }
        auth.hostName = hostName.toLowerCase();
        auth.port = this.extractPort(name, uri);
        if (name.length() > 0 && name.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", uri);
        }
        return auth;
    }

    protected String extractUserInfo(StringBuffer name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch == '@') {
                String userInfo = name.substring(0, pos);
                name.delete(0, pos + 1);
                return userInfo;
            }
            if (ch == '/' || ch == '?') break;
        }
        return null;
    }

    protected String extractHostName(StringBuffer name) {
        char ch;
        int pos;
        int maxlen = name.length();
        for (pos = 0; pos < maxlen && (ch = name.charAt(pos)) != '/' && ch != ';' && ch != '?' && ch != ':' && ch != '@' && ch != '&' && ch != '=' && ch != '+' && ch != '$' && ch != ','; ++pos) {
        }
        if (pos == 0) {
            return null;
        }
        String hostname = name.substring(0, pos);
        name.delete(0, pos);
        return hostname;
    }

    protected int extractPort(StringBuffer name, String uri) throws FileSystemException {
        char ch;
        int pos;
        if (name.length() < 1 || name.charAt(0) != ':') {
            return -1;
        }
        int maxlen = name.length();
        for (pos = 1; pos < maxlen && (ch = name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        String port = name.substring(1, pos);
        name.delete(0, pos);
        if (port.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", uri);
        }
        return Integer.parseInt(port);
    }

    protected static class Authority {
        public String scheme;
        public String hostName;
        public String userName;
        public String password;
        public int port;

        protected Authority() {
        }
    }
}

