/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http;

import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.HttpClient;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.UserAuthenticationData;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpClientFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.UserAuthenticatorUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class HttpFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public HttpFileProvider() {
        this.setFileNameParser(HttpFileNameParser.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClient = HttpClientFactory.createConnection(rootName.getScheme(), rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()))), fileSystemOptions);
        }
        finally {
            UserAuthenticatorUtils.cleanup(authData);
        }
        return new HttpFileSystem(rootName, httpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return HttpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

