/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.temp;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.FileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.UriParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local.LocalFileSystem;
import java.io.File;
import java.util.Collection;

public class TemporaryFileProvider
extends AbstractFileProvider
implements FileProvider,
Comparable {
    private File rootFile;

    public TemporaryFileProvider(File rootFile) {
        this();
        this.rootFile = rootFile;
    }

    public TemporaryFileProvider() {
    }

    public int compareTo(Object o) {
        int h2;
        int h1 = this.hashCode();
        if (h1 < (h2 = o.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        StringBuffer buffer = new StringBuffer(uri);
        String scheme = UriParser.extractScheme(uri, buffer);
        UriParser.fixSeparators(buffer);
        FileType fileType = UriParser.normalisePath(buffer);
        String path = buffer.toString();
        FileSystem filesystem = this.findFileSystem(this, properties);
        if (filesystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName rootName = this.getContext().parseURI(scheme + ":" + "/");
            filesystem = new LocalFileSystem(rootName, this.rootFile.getAbsolutePath(), properties);
            this.addFileSystem(this, filesystem);
        }
        return filesystem.resolveFile(path);
    }

    public Collection getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

