/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.api.TwitterToken;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.directions.ModifiableExampleClass;
import com.crashlytics.tools.android.onboard.dsl.transform.CodeChangeBuilder;
import com.crashlytics.tools.android.onboard.kits.KitClassTransformFactory;
import com.crashlytics.tools.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class ClassOnboarder
extends EmptyOnboarder {
    protected final boolean _hasKitsEnabled;
    protected final List<Kit> _kits;
    protected final Optional<TwitterToken> _twittertoken;

    public ClassOnboarder(List<Kit> kits, boolean hasKitsEnabled, Optional<TwitterToken> twitterToken) {
        this._hasKitsEnabled = hasKitsEnabled;
        this._kits = kits;
        this._twittertoken = twitterToken;
    }

    @Override
    public abstract List<CodeChange> getCodeChanges() throws OnboardException;

    @Override
    public List<CodeChange> getCodeChangeDirections() {
        try {
            String content = this.getDefaultJavaActivityContents();
            ModifiableExampleClass exampleClass = new ModifiableExampleClass("Start Activity", content, this.getLocationsOfCodeInjections());
            ClassOnboarder.getCodeChangeBuilder("Start Activity", this._hasKitsEnabled, this._kits, this._twittertoken).apply(exampleClass);
            return Collections.singletonList(exampleClass.getCodeChange());
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics could not parse the locations file.", null);
            return Collections.singletonList(CodeChange.createEmptyChange("Start Activity"));
        }
        catch (OnboardException e) {
            DeveloperTools.logW("Crashlytics could not create injections into the example document.", null);
            return Collections.singletonList(CodeChange.createEmptyChange("Start Activity"));
        }
    }

    public Map<String, Integer> getLocationsOfCodeInjections() throws IOException {
        Properties propertiesFromDisk = new Properties();
        propertiesFromDisk.load(this.getExamplesStream("MainActivityLocations.properties"));
        HashMap<String, Integer> locations = new HashMap<String, Integer>();
        for (Object property : propertiesFromDisk.keySet()) {
            locations.put((String)property, Integer.valueOf((String)propertiesFromDisk.get(property)));
        }
        return locations;
    }

    public InputStream getExamplesStream(String examplePath) throws IOException {
        return ClassOnboarder.class.getClassLoader().getResourceAsStream("examples/" + examplePath);
    }

    private String getDefaultJavaActivityContents() throws IOException {
        return FileUtils.streamToString(this.getExamplesStream("MainActivity.java.txt"));
    }

    protected boolean hasKitsEnabled() {
        return this._hasKitsEnabled;
    }

    public static CodeChangeBuilder getCodeChangeBuilder(String classToModify, boolean hasKitsEnabled, List<Kit> kits, Optional<TwitterToken> twitterToken) {
        CodeChangeBuilder builder = CodeChangeBuilder.create();
        if (hasKitsEnabled) {
            builder = kits.contains(OnboardingConstants.CRASHLYTICS_KIT) ? builder.with(CodeChangeBuilder.delete(OnboardingConstants.getLegacyStartMethod())) : builder.transformIf(CodeChangeBuilder.delete(OnboardingConstants.getLegacyStartMethod()), KitClassTransformFactory.create(hasKitsEnabled, OnboardingConstants.CRASHLYTICS_KIT, twitterToken));
        }
        for (Kit kit : kits) {
            builder = builder.with(KitClassTransformFactory.create(hasKitsEnabled, kit, twitterToken));
        }
        return builder;
    }
}

