/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.reloc.com.google.common.base.Predicate;
import com.crashlytics.reloc.com.google.common.collect.Iterables;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.utils.Graph;
import com.crashlytics.tools.utils.GraphUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AndroidLibraryGraph {
    private final List<AndroidLibrary> _topoSort;
    private final Graph<AndroidLibrary> _dependenciesPerLibrary;
    private final List<AndroidLibrary> _rootLibraries;
    public static final Predicate<AndroidLibrary> ONLY_AAR_LIBRARIES = new Predicate<AndroidLibrary>(){

        @Override
        public boolean apply(AndroidLibrary library) {
            return library.isAar();
        }
    };

    public AndroidLibraryGraph(Graph<AndroidLibrary> dependenciesPerLibrary, List<AndroidLibrary> rootLibraries) {
        this._dependenciesPerLibrary = dependenciesPerLibrary;
        this._rootLibraries = rootLibraries;
        try {
            this._topoSort = GraphUtils.topologicalSort(dependenciesPerLibrary);
        }
        catch (GraphUtils.GraphCycleException e) {
            throw new IllegalArgumentException("A cycle was found in this dependency graph.", e);
        }
    }

    public Iterable<AndroidLibrary> getTransitiveJarDependencies(AndroidLibrary library) {
        Collection<AndroidLibrary> dependencies = this.getDependencies(library);
        HashSet<AndroidLibrary> libsAdded = new HashSet<AndroidLibrary>();
        LinkedList<AndroidLibrary> libsToProcess = new LinkedList<AndroidLibrary>(dependencies);
        while (!libsToProcess.isEmpty()) {
            AndroidLibrary currentLib = libsToProcess.pop();
            if (currentLib.isAar()) continue;
            libsToProcess.addAll(this.getDependencies(currentLib));
            libsAdded.add(currentLib);
        }
        return libsAdded;
    }

    public Iterable<AndroidLibrary> getDirectAarDependencies(AndroidLibrary library) {
        return Iterables.filter(this.getDependencies(library), ONLY_AAR_LIBRARIES);
    }

    private Collection<AndroidLibrary> getDependencies(AndroidLibrary lib) {
        Set<AndroidLibrary> dependencies = this._dependenciesPerLibrary.getNeighbors(lib);
        return dependencies == null ? Collections.emptyList() : Collections.unmodifiableCollection(dependencies);
    }

    public Iterable<AndroidLibrary> getLibraries() {
        return this._dependenciesPerLibrary;
    }

    public List<AndroidLibrary> getRootLibraries() {
        return this._rootLibraries;
    }

    public List<AndroidLibrary> getTopologicalSort() {
        return this._topoSort;
    }

    public String toString() {
        return "Library Graph:" + this._dependenciesPerLibrary;
    }

    public Iterable<AndroidLibrary> getAarLibraries() {
        return Iterables.filter(this.getLibraries(), ONLY_AAR_LIBRARIES);
    }
}

