/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.primitives.Chars;
import com.crashlytics.reloc.org.apache.commons.cli.CommandLine;
import com.crashlytics.reloc.org.apache.commons.cli.GnuParser;
import com.crashlytics.reloc.org.apache.commons.cli.Options;
import com.crashlytics.reloc.org.apache.commons.cli.ParseException;
import com.crashlytics.reloc.org.apache.commons.codec.binary.Base64;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SecretObfuscator {
    private static int atoi(char a) {
        return a - 48;
    }

    private static char itoa(int i) {
        return (char)(i + 48);
    }

    public static char[] reconstitute(char[][] parts, char[] order) {
        int result = 0;
        int offset = 0;
        for (int i = 0; i < order.length; ++i) {
            result += parts[i].length;
        }
        char[] reconstituted = new char[result];
        for (int i = 0; i < order.length; ++i) {
            char[] part = parts[SecretObfuscator.atoi(order[i])];
            System.arraycopy(part, 0, reconstituted, offset, part.length);
            offset += part.length;
        }
        return reconstituted;
    }

    public static char[][] split(byte[] bytes, int chunkLength) {
        int size = (int)Math.ceil((double)bytes.length / (double)chunkLength);
        int offset = 0;
        int remaining = bytes.length;
        char[][] parts = new char[size][];
        for (int i = 0; i < size; ++i) {
            parts[i] = new String(Arrays.copyOfRange(bytes, offset, offset + chunkLength), 0, Math.min(chunkLength, remaining)).toCharArray();
            offset += chunkLength;
            remaining -= chunkLength;
        }
        return parts;
    }

    public static String decode(char[][] what, char[] encodedShuffle, char[] decodedShuffle) {
        char[] encodedReconstituted = SecretObfuscator.reconstitute(what, encodedShuffle);
        byte[] encodedReconstitutedBytes = new String(encodedReconstituted).getBytes();
        byte[] decoded = Base64.decodeBase64(encodedReconstitutedBytes);
        return new String(SecretObfuscator.reconstitute(SecretObfuscator.split(decoded, 8), decodedShuffle));
    }

    private static String shuffle(String order) {
        List<Character> chars = Chars.asList(order.toCharArray());
        Collections.shuffle(chars);
        return Joiner.on("").join(chars);
    }

    public static char[][] encode(String what, String order, String encodedOrder) {
        char[] shuffled = SecretObfuscator.reconstitute(SecretObfuscator.split(what.getBytes(), 8), order.toCharArray());
        byte[] encoded = Base64.encodeBase64(new String(shuffled).getBytes());
        char[][] parts = SecretObfuscator.split(encoded, 16);
        char[][] encodedOrdered = new char[parts.length][];
        for (int i = 0; i < encodedOrder.length(); ++i) {
            int part = SecretObfuscator.atoi((char)encodedOrder.getBytes()[i]);
            encodedOrdered[i] = parts[part];
        }
        return encodedOrdered;
    }

    private static String generateEncoded(String what, String order, String encodedOrder) {
        StringBuilder builder = new StringBuilder();
        char[][] encoded = SecretObfuscator.encode(what, order, encodedOrder);
        for (int i = 0; i < encoded.length; ++i) {
            builder.append("\t\t\t\"" + new String(encoded[i], 0, encoded[i].length) + "\".toCharArray(),\n");
        }
        return builder.toString();
    }

    private static String index(String order) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < order.length(); ++i) {
            builder.append(order.indexOf(SecretObfuscator.itoa(i)));
        }
        return builder.toString();
    }

    private static String generateConstants(String appId, String secret) {
        StringBuilder builder = new StringBuilder();
        String appIdOrder = SecretObfuscator.shuffle("01234567");
        String appIdEncodedOrder = SecretObfuscator.shuffle("012345");
        String secretOrder = SecretObfuscator.shuffle("01234567");
        String secretEncodedOrder = SecretObfuscator.shuffle("012345");
        builder.append("\tprivate static final char[][] ENCODED_APP_ID = new char[][]{\n");
        builder.append(SecretObfuscator.generateEncoded(appId, appIdOrder, appIdEncodedOrder));
        builder.append("\t};\n");
        builder.append("\tprivate static final char[][] ENCODED_SECRET = new char[][]{\n");
        builder.append(SecretObfuscator.generateEncoded(secret, secretOrder, secretEncodedOrder));
        builder.append("\t};\n");
        builder.append("\tprivate static final char[][] SHUFFLE = new char[][]{\n");
        builder.append("\t\t\t\"" + SecretObfuscator.index(appIdOrder) + "\".toCharArray(), // AppId ordering\n");
        builder.append("\t\t\t\"" + SecretObfuscator.index(appIdEncodedOrder) + "\".toCharArray(),   // AppId encoded ordering\n");
        builder.append("\t\t\t\"" + SecretObfuscator.index(secretOrder) + "\".toCharArray(), // Secret ordering\n");
        builder.append("\t\t\t\"" + SecretObfuscator.index(secretEncodedOrder) + "\".toCharArray()    // Secret encoded ordering\n");
        builder.append("\t};\n");
        return builder.toString();
    }

    private static String generate(String appId, String secret) {
        StringBuilder builder = new StringBuilder();
        builder.append("For app-id {" + appId + "}, and secret {" + secret + "}, the code is:\n");
        builder.append("---------------------------------------------------------------------\n");
        builder.append("\t// The following block is auto-generated by the SecretObfuscator utility\n");
        builder.append("\t// Do not change unless you know what you are doing!\n");
        builder.append("\t//\n");
        builder.append("\t// GENERATED CODE BEGIN\n");
        builder.append(SecretObfuscator.generateConstants(appId, secret));
        builder.append("\t// GENERATED CODE END\n");
        builder.append("---------------------------------------------------------------------\n");
        return builder.toString();
    }

    private static boolean validate(String what, String caption) {
        if (what == null) {
            System.out.println("No " + caption + " is specified");
            return false;
        }
        if (what.length() != 64) {
            System.out.println("The " + caption + " needs to be of length 64");
            return false;
        }
        return true;
    }

    private static String usage() {
        return "Usage:\n-a <app-id> -s <secret>\n\nGenerates proper code for the given app-id and secret\n";
    }

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("a", true, "app-id");
        options.addOption("s", true, "secret");
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, args);
            String appId = cmd.getOptionValue("a");
            String secret = cmd.getOptionValue("s");
            if (!SecretObfuscator.validate(appId, "appId") || !SecretObfuscator.validate(secret, "secret")) {
                return;
            }
            System.out.println(SecretObfuscator.generate(appId, secret));
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println(SecretObfuscator.usage());
        }
    }
}

