/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.utils.Graph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SparseDirectedGraph<T>
implements Graph<T> {
    private final Map<T, Set<T>> _linksByNode;

    public SparseDirectedGraph(Graph<T> graph) {
        this(SparseDirectedGraph.createAdjacencies(graph));
    }

    public SparseDirectedGraph(Map<T, Set<T>> linksByNode) {
        this._linksByNode = linksByNode;
    }

    @Override
    public Iterator<T> iterator() {
        return this._linksByNode.keySet().iterator();
    }

    @Override
    public Set<T> getNeighbors(T lib) {
        return this._linksByNode.get(lib);
    }

    @Override
    public int size() {
        return this._linksByNode.size();
    }

    private static <T> Map<T, Set<T>> createAdjacencies(Graph<T> graph) {
        HashMap returnAdjacencies = new HashMap();
        for (Object node : graph) {
            returnAdjacencies.put(node, new HashSet<T>(graph.getNeighbors(node)));
        }
        return returnAdjacencies;
    }

    public void remove(T lib) {
        this._linksByNode.remove(lib);
    }

    public String toString() {
        return "Graph:" + this._linksByNode;
    }
}

