/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.io;

import com.crashlytics.tools.utils.io.SeekableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class ByteReader
implements Closeable {
    private static final int LONG_WIDTH = 8;
    private static final int INT_WIDTH = 4;
    private static final int SHORT_WIDTH = 2;
    private static final int BUFFER_SIZE = 64;
    private final byte[] _bytes = new byte[64];
    private final ByteBuffer _buffer = ByteBuffer.allocate(this._bytes.length);
    private final SeekableInputStream _source;

    public ByteReader(SeekableInputStream source) {
        this._source = source;
    }

    public void seek(long offset) throws IOException {
        this._source.seek(offset);
    }

    public long getCurrentOffset() throws IOException {
        return this._source.getCurrentOffset();
    }

    @Override
    public void close() throws IOException {
        this._source.close();
    }

    public byte readByte() throws IOException {
        int b = this._source.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)(b & 0xFF);
    }

    public byte[] readBytes(int numBytes) throws IOException {
        byte[] bytes = new byte[numBytes];
        this._source.readFully(bytes, 0, bytes.length);
        return bytes;
    }

    public short readShort(int numBytes) throws IOException {
        this._buffer.put(this.readNumber(this._bytes, numBytes, 2, this._buffer.order()));
        this._buffer.flip();
        short answer = this._buffer.getShort();
        this._buffer.clear();
        return answer;
    }

    public int readInt(int numBytes) throws IOException {
        this._buffer.put(this.readNumber(this._bytes, numBytes, 4, this._buffer.order()));
        this._buffer.flip();
        int answer = this._buffer.getInt();
        this._buffer.clear();
        return answer;
    }

    public long readLong(int numBytes) throws IOException {
        this._buffer.put(this.readNumber(this._bytes, numBytes, 8, this._buffer.order()));
        this._buffer.flip();
        long answer = this._buffer.getLong();
        this._buffer.clear();
        return answer;
    }

    public String readNullTerminatedString(Charset charset) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int b = this._source.read();
        while (b != 0) {
            if (b < 0) {
                throw new EOFException();
            }
            bos.write(b);
            b = this._source.read();
        }
        return new String(bos.toByteArray(), charset);
    }

    public int readULEB128() throws IOException {
        int value = 0;
        int shift = 0;
        while (true) {
            byte b = this.readByte();
            value |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return value;
    }

    public void setByteOrder(ByteOrder order) {
        this._buffer.order(order);
    }

    public ByteOrder getByteOrder() {
        return this._buffer.order();
    }

    private byte[] readNumber(byte[] buffer, int numBytes, int width, ByteOrder order) throws IOException {
        if (numBytes > width) {
            throw new IllegalArgumentException(String.format("Requested number of bytes (%d) was greater than available bytes (%d).", numBytes, width));
        }
        this._source.readFully(buffer, 0, numBytes);
        return this.padBytes(buffer, numBytes, width, order);
    }

    private byte[] padBytes(byte[] data, int dataLen, int totalWidth, ByteOrder order) {
        byte[] padded = new byte[totalWidth];
        int dest = order == ByteOrder.BIG_ENDIAN ? totalWidth - dataLen : 0;
        System.arraycopy(data, 0, padded, dest, dataLen);
        return padded;
    }
}

