/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@org.apache.maven.plugins.annotations.Mojo(name="CleanupResources", defaultPhase=LifecyclePhase.PACKAGE)
public class CrashlyticsCleanupResourcesMojo
extends AbstractCrashlyticsMojo {
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidAssetsPath;
    @Parameter
    private String androidManifestPath;
    @Parameter(defaultValue="target/proguard/mapping.txt", alias="mapping_location")
    private String mappingFilePath;
    @Parameter(defaultValue="false", alias="force_mapping_upload")
    private String forceMappingUpload;
    @Parameter(defaultValue="crashlytics.properties", alias="properties_path")
    private String propertiesPath;
    @Parameter(defaultValue="false", alias="require_upload_success")
    private String requireUploadSuccess;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Crashlytics - CleanupResources");
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("mappingFilePath: " + this.mappingFilePath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidAssetsPath: " + this.androidAssetsPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("forceMappingUpload: " + this.forceMappingUpload));
        this.getLog().debug((CharSequence)("requireUploadSuccess: " + this.requireUploadSuccess));
        this.getLog().debug((CharSequence)("propertiesPath: " + this.propertiesPath));
        if (this.projectPath == null) {
            this.projectPath = this.getDefaultProjectPath();
            this.getLog().debug((CharSequence)("projectPath set to Maven project basedir: " + this.projectPath));
        }
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        boolean obfuscating = Boolean.parseBoolean(this.forceMappingUpload) || this.isProGuardEnabled(this.getMavenProject());
        String mappingAbsolutePath = new File(this.projectPath, this.mappingFilePath).getAbsolutePath();
        DeveloperToolsUtils util = new DeveloperToolsUtils(this.projectPath, this.androidResPath, this.androidAssetsPath, this.androidManifestPath, this.propertiesPath, this.requireUploadSuccess, obfuscating, mappingAbsolutePath, this.getRenamedPackage(), null);
        util.storeDeobsFile();
        util.cleanupResourceFile();
        util.uploadDeobsFiles();
    }

    private boolean isProGuardEnabled(MavenProject project) {
        boolean skipped = true;
        for (Object obj : project.getBuildPlugins()) {
            Xpp3Dom skipDom;
            Xpp3Dom proguardDom;
            Plugin plugin = (Plugin)obj;
            if (!"android-maven-plugin".equals(plugin.getArtifactId())) continue;
            Xpp3Dom dom = (Xpp3Dom)plugin.getConfiguration();
            if (dom == null || (proguardDom = dom.getChild("proguard")) == null || (skipDom = proguardDom.getChild("skip")) == null) break;
            skipped = Boolean.parseBoolean(skipDom.getValue());
            break;
        }
        this.getLog().debug((CharSequence)("ProGuard skip = " + skipped));
        return !skipped;
    }
}

