/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@org.apache.maven.plugins.annotations.Mojo(name="UploadDistribution")
public class CrashlyticsUploadDistributionMojo
extends AbstractCrashlyticsMojo {
    private static final String APK = ".apk";
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidAssetsPath;
    @Parameter
    private String androidManifestPath;
    @Parameter(defaultValue="crashlytics.properties", alias="properties_path")
    private String propertiesPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Crashlytics - UploadDistribution");
        String apkFileName = this.getApkFileName();
        this.getLog().info((CharSequence)("Uploading " + apkFileName + " to Crashlytics..."));
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidAssetsPath: " + this.androidAssetsPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("propertiesPath: " + this.propertiesPath));
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        DeveloperToolsUtils util = new DeveloperToolsUtils(this.projectPath, this.androidResPath, this.androidAssetsPath, this.androidManifestPath, this.propertiesPath, null, false, null, this.getRenamedPackage(), apkFileName);
        util.uploadDistribution();
    }

    private String getApkFileName() {
        MavenProject project = this.getMavenProject();
        File apkFile = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + APK);
        return apkFile.getAbsolutePath();
    }
}

