/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.EnrollmentsJsonTransform;
import com.crashlytics.api.App;
import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.Features;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.ProgressReportingHttpEntity;
import com.crashlytics.api.Software;
import com.crashlytics.api.TwitterApp;
import com.crashlytics.api.TwitterAppDetail;
import com.crashlytics.api.User;
import com.crashlytics.api.WebApi;
import com.crashlytics.api.net.auth.OAuthClient;
import com.crashlytics.api.net.proxy.ProtocolScheme;
import com.crashlytics.api.net.proxy.ProxySettings;
import com.crashlytics.api.ota.OrganizationPeopleJsonTransform;
import com.crashlytics.api.ota.Person;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseJsonTransform;
import com.crashlytics.api.ota.ReleaseNotes;
import com.crashlytics.api.ota.ReleaseNotesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.api.storage.FileStore;
import com.crashlytics.api.storage.Hexifier;
import com.crashlytics.reloc.com.google.common.base.Function;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.gson.Gson;
import com.crashlytics.reloc.com.google.gson.JsonObject;
import com.crashlytics.reloc.com.google.gson.JsonParseException;
import com.crashlytics.reloc.com.google.gson.JsonParser;
import com.crashlytics.reloc.com.google.gson.reflect.TypeToken;
import com.crashlytics.reloc.org.apache.commons.codec.binary.Base64;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.reloc.org.apache.http.Header;
import com.crashlytics.reloc.org.apache.http.HttpEntity;
import com.crashlytics.reloc.org.apache.http.HttpResponse;
import com.crashlytics.reloc.org.apache.http.client.HttpClient;
import com.crashlytics.reloc.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpGet;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpPost;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpPut;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpRequestBase;
import com.crashlytics.reloc.org.apache.http.client.utils.URLEncodedUtils;
import com.crashlytics.reloc.org.apache.http.entity.ByteArrayEntity;
import com.crashlytics.reloc.org.apache.http.entity.ContentType;
import com.crashlytics.reloc.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.crashlytics.reloc.org.apache.http.entity.mime.content.FileBody;
import com.crashlytics.reloc.org.apache.http.entity.mime.content.StringBody;
import com.crashlytics.reloc.org.apache.http.impl.client.CloseableHttpClient;
import com.crashlytics.reloc.org.apache.http.impl.client.HttpClients;
import com.crashlytics.reloc.org.apache.http.message.BasicNameValuePair;
import com.crashlytics.reloc.org.json.simple.JSONArray;
import com.crashlytics.reloc.org.json.simple.JSONAware;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.reloc.org.json.simple.JSONValue;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RestfulWebApi
implements WebApi {
    private static final String FATAL_TYPE = "fatal";
    private static final String NONFATAL_TYPE = "nonfatal";
    private static final String DEV_TOKEN = "ed8fc3dc68a7475cc970eb1e9c0cb6603b0a3ea2";
    private static final String USER_TAG = "User";
    private static final String ORGS_TAG = "Orgs";
    private static final String FEATURES_TAG = "Features";
    private static final String USER_TAG_OAUTH = "User-OAuth";
    private static final String OAUTH_TOKEN_FIELD_TAG = "oauth-token";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DISTRIBUTION_ANDROID_APP_TYPE = "android_app";
    private static final String DISTRIBUTION_SLICE_JAVA_ARCH = "java";
    private Features _features = new Features();
    private User _user = null;
    private List<App> _appsCache = null;
    private List<Organization> _orgsCache = null;
    private Map<App, List<Issue>> _issuesCache;
    private String _userAgent;
    private String _clientVersion = null;
    private String _clientType = null;
    private String _toolId = null;
    private String _toolVersion = null;
    private String _operatingSystem = null;
    private String _environmentId = null;
    private String _environmentVersion = null;
    private boolean _oauthEnabled = false;
    private OAuthClient _oauthClient = null;
    private OAuthClient.Token _oauthToken = null;
    private String _baseApiUrl;
    private String _codeMappingApiUrl;

    public String toString() {
        return " ClientType: " + this._clientType + " (" + this._clientVersion + ") ToolId: " + this._toolId + " (" + this._toolVersion + ") Operating System: " + this._operatingSystem + " Environment: " + this._environmentId + " (" + this._environmentVersion + ")";
    }

    private HttpResponse request(HttpRequestBase request) throws IOException, AuthenticationException {
        return this.request(request, true);
    }

    private HttpResponse request(HttpRequestBase request, boolean reauthenticateOnUnauthorized) throws IOException, AuthenticationException {
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(request));
        request.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(request);
        RestfulWebApi.logRequest(request);
        HttpClient client = proxySettings.getClientFor();
        HttpResponse response = client.execute(request);
        RestfulWebApi.logResponse(response, response.getStatusLine().getStatusCode());
        if (this._oauthEnabled && RestfulWebApi.isUnauthorized(response.getStatusLine().getStatusCode()) && reauthenticateOnUnauthorized) {
            response = this.reauthenticateAndRetryViaOAuth(response, request, client);
            RestfulWebApi.logResponse(response, response.getStatusLine().getStatusCode());
        }
        return response;
    }

    public RestfulWebApi() {
        this("https://api.crashlytics.com", "https://cm.crashlytics.com");
    }

    public RestfulWebApi(String baseApiUrl, String codeMappingApiUrl) {
        this(baseApiUrl, codeMappingApiUrl, false);
    }

    public RestfulWebApi(String baseApiUrl, String codeMappingApiUrl, boolean oauthEnabled) {
        this._baseApiUrl = baseApiUrl;
        this._codeMappingApiUrl = codeMappingApiUrl;
        this._issuesCache = new HashMap<App, List<Issue>>();
        this._oauthEnabled = oauthEnabled;
        if (this._oauthEnabled) {
            JSONObject jsonFeatures;
            try {
                this._oauthClient = new OAuthClient(new URI(baseApiUrl));
            }
            catch (URISyntaxException e) {
                DeveloperTools.logW("Crashlytics unexpectedly encountered a malformed URI.", e);
            }
            Optional<JSONObject> jsonUser = RestfulWebApi.loadFromEncodedCache(USER_TAG_OAUTH);
            if (jsonUser.isPresent()) {
                this._oauthToken = new Gson().fromJson(jsonUser.get().get(OAUTH_TOKEN_FIELD_TAG).toString(), OAuthClient.Token.class);
                this._user = RestfulWebApi.updateUserCache(jsonUser.get(), this._oauthToken, false);
            }
            if ((jsonFeatures = (JSONObject)RestfulWebApi.loadFromCache(FEATURES_TAG)) != null) {
                this._features = RestfulWebApi.updateFeaturesCache(Optional.of(jsonFeatures), false);
            }
        } else {
            JSONObject jsonUser = (JSONObject)RestfulWebApi.loadFromCache(USER_TAG);
            if (jsonUser != null) {
                this._user = RestfulWebApi.updateUserCache(jsonUser, false);
            }
        }
        JSONArray jsonOrgs = (JSONArray)RestfulWebApi.loadFromCache(ORGS_TAG);
        if (jsonOrgs != null) {
            this._orgsCache = RestfulWebApi.updateOrgsCache(jsonOrgs, false);
        }
    }

    @Override
    public final synchronized void logout() {
        this._user = null;
        this._features = new Features();
        if (this._oauthEnabled) {
            RestfulWebApi.deleteFileInCache(USER_TAG_OAUTH);
            RestfulWebApi.deleteFileInCache(FEATURES_TAG);
        } else {
            RestfulWebApi.deleteFileInCache(USER_TAG);
        }
        RestfulWebApi.deleteFileInCache(ORGS_TAG);
        this._appsCache = null;
        this._orgsCache = null;
    }

    @Override
    public synchronized void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    @Override
    public synchronized void setClientType(String clientType) {
        this._clientType = clientType;
    }

    @Override
    public synchronized void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    @Override
    public final synchronized User authenticateUser(String email, String password) throws IOException {
        this.logout();
        if (this._oauthEnabled) {
            Optional<JSONObject> response = this.authenticateUserViaOAuth(email, password);
            if (response.isPresent()) {
                this._user = RestfulWebApi.updateUserCache(response.get(), this._oauthToken, true);
                this._orgsCache = RestfulWebApi.updateOrgsCache((JSONArray)response.get().get("organizations"), true);
                try {
                    this._features = RestfulWebApi.updateFeaturesCache(this.fetchFeatures(), true);
                }
                catch (AuthenticationException e) {
                    this._features = new Features();
                }
            }
        } else {
            Optional<JSONObject> response = this.authenticateUserViaLegacy(email, password);
            if (response.isPresent()) {
                this._user = RestfulWebApi.updateUserCache(response.get(), true);
                this._orgsCache = RestfulWebApi.updateOrgsCache((JSONArray)response.get().get("organizations"), true);
            }
        }
        return this._user;
    }

    @Override
    public boolean verifyCredentials(String username, String password) throws IOException {
        String authString = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64(authString.getBytes());
        HttpGet get = new HttpGet("https://android-sdk.crashlytics.com/twittersdk/api/repositories");
        get.setHeader("Authorization", "Basic " + new String(encodedAuth));
        CloseableHttpClient client = HttpClients.createDefault();
        HttpResponse response = client.execute(get);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    private static Features updateFeaturesCache(Optional<JSONObject> json, boolean flushToDisk) {
        if (!json.isPresent()) {
            return new Features();
        }
        if (flushToDisk) {
            RestfulWebApi.writeJSONToFile(FEATURES_TAG, json.get());
        }
        return new Features.Parser(){

            @Override
            public <T> Features parse(T raw) {
                return new Gson().fromJson((String)raw, Features.class);
            }
        }.parse(json.get().toJSONString());
    }

    private static List<Organization> updateOrgsCache(JSONArray jsonOrgs, boolean flushToDisk) {
        LinkedList<Organization> cache = new LinkedList<Organization>();
        if (jsonOrgs != null) {
            if (flushToDisk) {
                RestfulWebApi.writeJSONToFile(ORGS_TAG, jsonOrgs);
            }
            for (Object element : jsonOrgs) {
                cache.add(new Organization((JSONObject)element));
            }
        }
        return cache;
    }

    private static User updateUserCache(JSONObject jsonUser, boolean flushToDisk) {
        if (flushToDisk) {
            RestfulWebApi.writeJSONToFile(USER_TAG, jsonUser);
        }
        String name = (String)jsonUser.get("name");
        String email = (String)jsonUser.get("email");
        String token = (String)jsonUser.get("token");
        return User.create(email, name, token);
    }

    private static User updateUserCache(JSONObject jsonUser, OAuthClient.Token token, boolean flushToDisk) {
        if (flushToDisk) {
            Hexifier storage = new Hexifier(RestfulWebApi.getCachePathTo(USER_TAG_OAUTH));
            jsonUser.put(OAUTH_TOKEN_FIELD_TAG, new Gson().toJson(token));
            try {
                storage.put(jsonUser.toJSONString());
            }
            catch (IOException e) {
                DeveloperTools.logE("Crashlytics could not write the user", e);
            }
        }
        String name = (String)jsonUser.get("name");
        String email = null;
        JSONArray identities = (JSONArray)jsonUser.get("identities");
        for (Object identity : identities) {
            String service = (String)((JSONObject)identity).get("service");
            if (!service.equalsIgnoreCase("email")) continue;
            boolean primary = (Boolean)((JSONObject)identity).get("primary");
            boolean confirmed = (Boolean)((JSONObject)identity).get("confirmed");
            if (!primary || !confirmed) continue;
            email = (String)((JSONObject)identity).get("token");
            break;
        }
        return User.create(email, name, token);
    }

    private static User refreshUserCache(User currentUser, OAuthClient.Token token) {
        Hexifier storage = new Hexifier(RestfulWebApi.getCachePathTo(USER_TAG_OAUTH));
        Optional raw = storage.get();
        if (!raw.isPresent()) {
            return currentUser;
        }
        try {
            JsonObject user = (JsonObject)new JsonParser().parse((String)raw.get());
            user.addProperty(OAUTH_TOKEN_FIELD_TAG, new Gson().toJson(token));
            storage.put(user.toString());
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics couldn't persist the user cache", e);
        }
        catch (JsonParseException e) {
            DeveloperTools.logW("Crashlytics couldn't read the latest cache", e);
        }
        return User.create(currentUser.getEmail(), currentUser.getName(), token);
    }

    private synchronized Optional<JSONObject> authenticateUserViaLegacy(final String email, final String password) throws IOException {
        JSONObject request = new JSONObject(){
            {
                this.put("email", email);
                this.put("password", password);
            }
        };
        ByteArrayEntity entity = new ByteArrayEntity(request.toString().getBytes());
        entity.setContentType("application/json");
        HttpPost post = new HttpPost(this.getBaseApiUrl() + "/api/v2/session");
        post.setEntity(entity);
        try {
            return this.requestJSON(post, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            return Optional.absent();
        }
    }

    private synchronized Optional<JSONObject> authenticateUserViaOAuth(String email, String password) throws IOException {
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(this._oauthClient.getBaseUrl().getPath()));
        HttpClient client = settings.getClientFor();
        this._oauthToken = this._oauthClient.getToken(client, email, password);
        if (this._oauthToken == null) {
            return Optional.absent();
        }
        try {
            return this.getJSON(new URI(this._baseApiUrl + "/api/v3/account"));
        }
        catch (URISyntaxException e) {
            DeveloperTools.logW("Crashlytics encountered a bad URI", e);
        }
        catch (AuthenticationException e) {
            DeveloperTools.logE("Crashlytics couldn't fetch the account information", e);
        }
        return Optional.absent();
    }

    private synchronized boolean reauthenticateUserViaOAuth() throws IOException {
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(this._oauthClient.getBaseUrl().getPath()));
        HttpClient client = settings.getClientFor();
        this._oauthToken = this._oauthClient.refreshToken(client, this._oauthToken);
        if (this._oauthToken == null) {
            return false;
        }
        this._user = RestfulWebApi.refreshUserCache(this._user, this._oauthToken);
        try {
            this._features = RestfulWebApi.updateFeaturesCache(this.fetchFeatures(), true);
        }
        catch (AuthenticationException e) {
            this._features = new Features();
        }
        return true;
    }

    private synchronized HttpResponse reauthenticateAndRetryViaOAuth(HttpResponse response, HttpRequestBase request, HttpClient client) throws AuthenticationException, IOException {
        int result;
        if (this._oauthToken != null && this._user != null && this.reauthenticateUserViaOAuth()) {
            response = client.execute(OAuthClient.sign(request, this._oauthToken));
        }
        if (RestfulWebApi.isUnauthorized(result = response.getStatusLine().getStatusCode())) {
            throw new AuthenticationException("Crashlytics Authentication failed [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        return response;
    }

    @Override
    public void asyncAuthenticate(final String email, final String password, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user;
                try {
                    user = RestfulWebApi.this.authenticateUser(email, password);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics User Authenticator").start();
    }

    @Override
    public final synchronized User authenticateWithToken(String token) throws IOException {
        URI uri;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("X-CRASHLYTICS-ACCESS-TOKEN", token);
        String uriStr = this.getBaseApiUrl() + "/api/v2/session";
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
            return null;
        }
        try {
            Optional response = this.getJSON(uri, headerParams);
            if (response.isPresent()) {
                this._user = RestfulWebApi.updateUserCache((JSONObject)response.get(), false);
            }
        }
        catch (AuthenticationException e) {
            DeveloperTools.logE("Unable to authenticate user.", e);
            return null;
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticateWithToken(final String token, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user;
                try {
                    user = RestfulWebApi.this.authenticateWithToken(token);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics Tokenized Authenticator").start();
    }

    @Override
    public synchronized Features getFeatures(boolean clearCache) throws IOException, AuthenticationException {
        if (this._oauthEnabled) {
            this._features = RestfulWebApi.updateFeaturesCache(this.fetchFeatures(), true);
        }
        return this._features;
    }

    private Optional<JSONObject> fetchFeatures() throws IOException, AuthenticationException {
        String url = this._baseApiUrl + "/api/v3/features?consumers=plugin";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        return RestfulWebApi.jsonFromResponse(this.request(get, false));
    }

    @Override
    public synchronized List<Organization> getOrgs(boolean clearCache) throws IOException, AuthenticationException {
        URI uri;
        if (!clearCache && this._orgsCache != null) {
            return Collections.unmodifiableList(this._orgsCache);
        }
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving organizations.");
        }
        String uriStr = this.getBaseApiUrl() + "/api/v2/organizations";
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
            return null;
        }
        this._orgsCache = this.getJSON(uri).transform(new Function<JSONArray, List<Organization>>(){

            @Override
            public List<Organization> apply(JSONArray input) {
                return RestfulWebApi.updateOrgsCache(input, true);
            }
        }).or(new LinkedList());
        return Collections.unmodifiableList(this._orgsCache);
    }

    @Override
    public void fetchApps(final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<App> apps;
                try {
                    apps = RestfulWebApi.this.getApps(true);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAppException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onRetrievedApps(RestfulWebApi.this, apps);
                }
            }
        }, "Crashlytics App Fetcher").start();
    }

    @Override
    public List<App> getApps(Organization org, boolean clearCache) throws IOException, AuthenticationException {
        List<App> allApps = this.getApps(clearCache);
        LinkedList<App> orgApps = new LinkedList<App>();
        for (App app : allApps) {
            if (!app.getOrganization().equals(org)) continue;
            orgApps.add(app);
        }
        return orgApps;
    }

    @Override
    public synchronized List<App> getApps(boolean clearCache) throws IOException, AuthenticationException {
        if (!clearCache && this._appsCache != null) {
            return Collections.unmodifiableList(this._appsCache);
        }
        this._appsCache = new LinkedList<App>();
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving apps.");
        }
        List<Organization> orgs = this.getOrgs(true);
        for (Organization org : orgs) {
            URI uri;
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + org.getId() + "/platforms/android/apps";
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
                return null;
            }
            Optional response = this.getJSON(uri);
            if (!response.isPresent()) continue;
            for (Object jsonApp : (JSONArray)response.get()) {
                App app = new App((JSONObject)jsonApp, org);
                if (!app.getPlatform().equalsIgnoreCase("android")) continue;
                this._appsCache.add(app);
            }
        }
        return Collections.unmodifiableList(this._appsCache);
    }

    @Override
    public synchronized List<Issue> getIssues(App app, boolean clearCache) throws IOException, AuthenticationException {
        LinkedList<Issue> allIssues = new LinkedList<Issue>();
        allIssues.addAll(this.getIssues(app, clearCache, FATAL_TYPE));
        allIssues.addAll(this.getIssues(app, clearCache, NONFATAL_TYPE));
        return allIssues;
    }

    private synchronized List<Issue> getIssues(App app, boolean clearCache, String issueType) throws IOException, AuthenticationException {
        if (clearCache) {
            this._issuesCache = new HashMap<App, List<Issue>>();
        }
        if (this._user == null) {
            throw new AuthenticationException("Crashlytics could not authenticate user while retrieving issues.");
        }
        if (!this._issuesCache.containsKey(app)) {
            URI uri;
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + app.getOrganization().getId() + "/apps/" + app.getId() + "/issues?event_type_equals=" + issueType;
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
                return null;
            }
            Optional response = this.getJSON(uri);
            LinkedList<Issue> issues = new LinkedList<Issue>();
            if (response.isPresent()) {
                DeveloperTools.logD("Issue RESPONSE:" + ((JSONArray)response.get()).toJSONString());
                for (Object issue : (JSONArray)response.get()) {
                    try {
                        issues.add(new Issue((JSONObject)issue, app));
                    }
                    catch (Exception e) {
                        DeveloperTools.logE("Couldn't parse issue", e);
                    }
                }
            }
            DeveloperTools.logD("Issues:" + issues.size());
            this._issuesCache.put(app, issues);
        }
        return this._issuesCache.containsKey(app) ? Collections.unmodifiableList(this._issuesCache.get(app)) : Collections.emptyList();
    }

    @Override
    public boolean sendFile(URL url, File file, String mimeType, String fileParamName, Map<String, String> bodyParams, String apiKey) throws IOException {
        HttpPost httpPost;
        DeveloperTools.logD("POST file: " + file + " to URL: " + url);
        try {
            httpPost = new HttpPost(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ContentType fileContentType = ContentType.create(mimeType);
        httpPost.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        this.applyCommonHeadersTo(httpPost);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry<String, String> param : bodyParams.entrySet()) {
            builder.addPart(param.getKey(), new StringBody(param.getValue(), ContentType.DEFAULT_TEXT));
        }
        builder.addPart(fileParamName, new FileBody(file, fileContentType, file.getName()));
        httpPost.setEntity(builder.build());
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = settings.getClientFor();
        httpPost.setConfig(settings.getConfig());
        HttpResponse response = client.execute(httpPost);
        int result = response.getStatusLine().getStatusCode();
        DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        return RestfulWebApi.isSuccess(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(URL url, File destination) throws IOException {
        HttpGet get;
        try {
            get = new HttpGet(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.applyCommonHeadersTo(get);
        get.addHeader("Accept", "application/octet-stream");
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = settings.getClientFor();
        get.setConfig(settings.getConfig());
        RestfulWebApi.logRequest(get);
        HttpResponse response = client.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        RestfulWebApi.logResponse(response, statusCode);
        if (statusCode == 200) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(destination);
                response.getEntity().writeTo(out);
                out.flush();
                boolean bl = true;
                return bl;
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        return false;
    }

    private void applyCommonHeadersTo(HttpRequestBase request) {
        request.addHeader("X-CRASHLYTICS-DEVELOPER-TOKEN", DEV_TOKEN);
        if (this._userAgent != null) {
            request.setHeader("User-Agent", this._userAgent);
        }
        if (this._clientType != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-TYPE", this._clientType);
        }
        if (this._clientVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-VERSION", this._clientVersion);
        }
        if (this._oauthEnabled) {
            request.removeHeaders("X-CRASHLYTICS-ACCESS-TOKEN");
            if (this._oauthToken != null) {
                OAuthClient.sign(request, this._oauthToken);
            }
        } else if (this._user != null) {
            request.addHeader("X-CRASHLYTICS-ACCESS-TOKEN", (String)this._user.getToken().token);
        }
        if (this._toolId != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-ID", this._toolId);
        }
        if (this._toolVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-BUILD-VERSION", this._toolVersion);
            request.setHeader("X-CRASHLYTICS-API-CLIENT-DISPLAY-VERSION", this._toolVersion);
        }
        if (this._operatingSystem != null) {
            request.setHeader("X-CRASHLYTICS-API-OPERATING-SYSTEM", this._operatingSystem);
        }
        if (this._environmentVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-ENVIRONMENT-VERSION", this._environmentVersion);
        }
        if (this._environmentId != null) {
            request.setHeader("X-CRASHLYTICS-API-ENVIRONMENT-ID", this._environmentVersion);
        }
    }

    private <T extends JSONAware> Optional<T> getJSON(URI uri) throws IOException, AuthenticationException {
        return this.getJSON(uri, Collections.<String, String>emptyMap());
    }

    private <T extends JSONAware> Optional<T> getJSON(URI uri, Map<String, String> headerParams) throws IOException, AuthenticationException {
        HttpGet get = new HttpGet(uri);
        return this.requestJSON(get, headerParams);
    }

    private <T extends JSONAware> Optional<T> requestJSON(HttpRequestBase request, Map<String, String> headerParams) throws IOException, AuthenticationException {
        request.setHeader("Accept", "application/json");
        for (Map.Entry<String, String> header : headerParams.entrySet()) {
            request.addHeader(header.getKey(), header.getValue().trim());
        }
        HttpResponse response = this.request(request);
        Optional<T> json = RestfulWebApi.jsonFromResponse(response);
        RestfulWebApi.logResponse(response, response.getStatusLine().getStatusCode(), json.orNull());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends JSONAware> Optional<T> jsonFromResponse(HttpResponse response) throws IOException {
        Optional<JSONAware> optional;
        if (!RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode())) {
            return Optional.absent();
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(response.getEntity().getContent(), UTF_8);
            optional = Optional.fromNullable((JSONAware)JSONValue.parse(reader));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return optional;
    }

    private static void logRequest(HttpRequestBase request) {
        DeveloperTools.logD("REQUEST: " + request.getURI());
    }

    private static void logResponse(HttpResponse response, int statusCodeResult, Object responseJSON) {
        DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]; " + responseJSON);
    }

    private static void logResponse(HttpResponse response, int statusCodeResult) {
        try {
            DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]");
        }
        catch (Exception e) {
            DeveloperTools.logE("Crashlytics experienced an error while logging a response.", e);
        }
    }

    @Override
    public Software getSoftwareIntegration(Organization org, String platform, String bundleId, String version) throws IOException {
        return this.getSoftwareIntegration(org.getApiKey(), platform, bundleId, version);
    }

    @Override
    public Software getSoftwareIntegration(String apiKey, String platform, String bundleId, String version) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + platform + "/integrations/" + bundleId + "?current_version=" + version);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Optional<JSONObject> result = Optional.absent();
        try {
            result = this.getJSON(uri);
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result.transform(new Function<JSONObject, Software>(){

            @Override
            public Software apply(JSONObject input) {
                return Software.createFromJSON(input);
            }
        }).orNull();
    }

    @Override
    public Software getAndroidSDK(Organization org, String currentVersion) throws IOException {
        return this.getAndroidSDK(org.getApiKey(), currentVersion);
    }

    @Override
    public Software getAndroidSDK(String apiKey, String currentVersion) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + "android" + "/sdks/com.crashlytics.android?current_version=" + currentVersion);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Optional<JSONObject> result = Optional.absent();
        try {
            result = this.getJSON(uri);
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result.transform(new Function<JSONObject, Software>(){

            @Override
            public Software apply(JSONObject input) {
                return Software.createFromJSON(input);
            }
        }).orNull();
    }

    @Override
    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    @Override
    public String getCodeMappingApiUrl() {
        return this._codeMappingApiUrl;
    }

    @Override
    public User getCurrentUser() {
        return this._user;
    }

    private static String getCachePathTo(String tag) {
        return DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath() + "/" + tag;
    }

    private static void writeJSONToFile(String tag, JSONObject json) {
        RestfulWebApi.writeJSONToFile(tag, json.toJSONString());
    }

    private static void writeJSONToFile(String tag, JSONArray json) {
        RestfulWebApi.writeJSONToFile(tag, json.toJSONString());
    }

    private static void writeJSONToFile(String tag, String raw) {
        FileStore storage = new FileStore(RestfulWebApi.getCachePathTo(tag + JSON_FILE_EXTENSION));
        try {
            storage.put(raw);
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not write " + storage.filename(), e);
        }
    }

    private static Optional<JSONObject> loadFromEncodedCache(String tag) {
        Hexifier storage = new Hexifier(RestfulWebApi.getCachePathTo(tag));
        Optional data = storage.get();
        return data.isPresent() ? Optional.of((JSONObject)JSONValue.parse((String)data.get())) : Optional.absent();
    }

    private static JSONAware loadFromCache(String tag) {
        FileStore storage = new FileStore(RestfulWebApi.getCachePathTo(tag + JSON_FILE_EXTENSION));
        Optional raw = storage.get();
        if (!raw.isPresent()) {
            return null;
        }
        return (JSONAware)JSONValue.parse((String)raw.get());
    }

    private static boolean deleteFileInCache(String tag) {
        return new FileStore(RestfulWebApi.getCachePathTo(tag + JSON_FILE_EXTENSION)).purge();
    }

    private static String getRequestId(HttpResponse response) {
        Header requestIdHeader = response.getFirstHeader("X-Request-Id");
        return requestIdHeader == null ? "null" : requestIdHeader.getValue();
    }

    @Override
    public boolean createDistribution(String apiKey, String buildSecret, AppRelease appRelease, DistributionData distributionData, boolean sendNotifications, final WebApi.UploadProgressListener listener) throws AuthenticationException, IOException {
        HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("send_notifications", new StringBody(Boolean.toString(sendNotifications), ContentType.DEFAULT_TEXT)).addPart("distribution[file]", new FileBody(distributionData.distributionFile, ContentType.DEFAULT_BINARY, distributionData.distributionFile.getName())).addPart("distribution[built_at]", new StringBody(Long.toString(distributionData.builtAtSeconds), ContentType.DEFAULT_TEXT)).addPart("app[instance_identifier]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).addPart("app[display_version]", new StringBody(appRelease.displayVersion, ContentType.DEFAULT_TEXT)).addPart("app[build_version]", new StringBody(appRelease.buildVersion, ContentType.DEFAULT_TEXT)).addPart("app[type]", new StringBody(DISTRIBUTION_ANDROID_APP_TYPE, ContentType.DEFAULT_TEXT)).addPart("app[slices][][arch]", new StringBody(DISTRIBUTION_SLICE_JAVA_ARCH, ContentType.DEFAULT_TEXT)).addPart("app[slices][][uuid]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).build();
        final long contentLength = multipartEntity.getContentLength();
        ProgressReportingHttpEntity progressEntity = new ProgressReportingHttpEntity(multipartEntity, new ProgressReportingHttpEntity.ProgressListener(){

            @Override
            public void bytesWritten(long count) {
                listener.bytesWritten(contentLength, count);
            }
        });
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appRelease.packageName + "/distributions";
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "application/json");
        post.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        post.setHeader("X-CRASHLYTICS-BUILD-SECRET", buildSecret);
        post.setEntity(progressEntity);
        HttpResponse response = this.request(post);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public JSONObject inviteTester(String apiKey, String appPackageName, String email, String name) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("email", email));
        nameValuePairs.add(new BasicNameValuePair("name", name));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/invitations";
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "application/json");
        post.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        post.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(post);
        Optional json = RestfulWebApi.jsonFromResponse(response);
        return (JSONObject)json.orNull();
    }

    @Override
    public ReleaseNotes getReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Optional json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseNotesJsonTransform().createReleaseNotesFrom((JSONObject)json.orNull());
    }

    @Override
    public boolean setReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, ReleaseNotes releaseNotes) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("release_notes[format]", releaseNotes.getFormat().name().toLowerCase()));
        nameValuePairs.add(new BasicNameValuePair("release_notes[body]", releaseNotes.getBody()));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes";
        HttpPut put = new HttpPut(url);
        put.setHeader("Accept", "application/json");
        put.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(put);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public Release getRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("include_disabled", "true"));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/summary?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Optional json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseJsonTransform().createReleaseFrom((JSONObject)json.orNull());
    }

    @Override
    public List<ReleaseSummary> getReleaseSummaries(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases_by_display_versions";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Optional json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseSummariesJsonTransform().createReleaseSummariesFrom((JSONObject)json.orNull());
    }

    @Override
    public Release getAccessToRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/access?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Optional json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new ReleaseJsonTransform().createAccessReleaseFrom((JSONObject)json.orNull());
    }

    @Override
    public boolean updateAccess(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, List<String> testerIds, List<String> groupIds, WebApi.AccessChange accessChange, boolean sendNotifications) throws AuthenticationException, IOException {
        return this.updateAccess(apiKey, appPackageName, instanceId, displayVersion, buildVersion, Collections.<String>emptyList(), testerIds, groupIds, accessChange, sendNotifications);
    }

    @Override
    public boolean updateAccess(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, List<String> emails, List<String> testerIds, List<String> groupIds, WebApi.AccessChange accessChange, boolean sendNotifications) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("send_notifications", Boolean.toString(sendNotifications)));
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        for (String email : emails) {
            nameValuePairs.add(new BasicNameValuePair("emails[]", email));
        }
        for (String testerId : testerIds) {
            nameValuePairs.add(new BasicNameValuePair("tester_ids[]", testerId));
        }
        for (String groupId : groupIds) {
            nameValuePairs.add(new BasicNameValuePair("group_ids[]", groupId));
        }
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/access/" + accessChange.getPathComponent();
        HttpPut put = new HttpPut(url);
        put.setHeader("Accept", "application/json");
        put.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        HttpResponse response = this.request(put);
        return RestfulWebApi.isSuccess(response.getStatusLine().getStatusCode());
    }

    @Override
    public List<Person> getPeopleInOrganization(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/testers_in_organization";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        get.setHeader("X-CRASHLYTICS-API-KEY", apiKey);
        Optional json = RestfulWebApi.jsonFromResponse(this.request(get));
        return new OrganizationPeopleJsonTransform().createPeopleFrom((JSONObject)json.orNull());
    }

    private static boolean isSuccess(int resultCode) {
        return resultCode >= 200 && resultCode < 300;
    }

    private static boolean isUnauthorized(int resultCode) {
        return resultCode == 401 || resultCode == 403;
    }

    @Override
    public void asyncNotifyBuildEvent(final String appPackageName, final String instanceId, final String orgId, final String buildSecretOrNull, final String extraDetailsOrNull) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RestfulWebApi.this.notifyBuildEvent(appPackageName, instanceId, orgId, buildSecretOrNull, extraDetailsOrNull);
            }
        }, "Build Event Notification").start();
    }

    public void notifyBuildEvent(String appPackageName, String instanceId, String orgId, String buildSecretOrNull, String extraDetailsOrNull) {
        DeveloperTools.logD("Build Event: " + appPackageName + " ID:" + instanceId + " ApiKey:" + orgId + " Tool:" + this._toolId + " " + this._toolVersion + " Extra Details:" + extraDetailsOrNull + " API Secret Null? " + (buildSecretOrNull == null));
        try {
            String url = this.getBaseApiUrl() + "/spi/v1/platforms/android/apps/" + appPackageName + "/built";
            ContentType mimeContentType = ContentType.create("text/plain");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("X-CRASHLYTICS-API-KEY", orgId);
            if (buildSecretOrNull != null) {
                httpPost.setHeader("X-CRASHLYTICS-BUILD-SECRET", buildSecretOrNull);
            }
            this.applyCommonHeadersTo(httpPost);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("app_name", new StringBody(appPackageName, mimeContentType));
            httpPost.setEntity(builder.build());
            if (extraDetailsOrNull != null) {
                builder.addPart("tool_detail", new StringBody(extraDetailsOrNull, mimeContentType));
            }
            ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(httpPost));
            HttpClient client = settings.getClientFor();
            httpPost.setConfig(settings.getConfig());
            RestfulWebApi.logRequest(httpPost);
            HttpResponse response = client.execute(httpPost);
            int result = response.getStatusLine().getStatusCode();
            DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        catch (IOException e) {
            DeveloperTools.logD("Crashlytics was unable to notify of build event. " + e.getClass() + ": " + e.getMessage());
        }
    }

    @Override
    public void setToolId(String toolId) {
        this._toolId = toolId;
    }

    @Override
    public void setToolVersion(String toolVersion) {
        this._toolVersion = toolVersion;
    }

    @Override
    public void setOperatingSystem(String os) {
        this._operatingSystem = os;
    }

    @Override
    public void setEnvironmentId(String environmentId) {
        this._environmentId = environmentId;
    }

    @Override
    public void setEnvironmentVersion(String environmentVersion) {
        this._environmentVersion = environmentVersion;
    }

    @Override
    public App getApp(String bundleId, boolean clearCache) throws IOException, AuthenticationException {
        if (bundleId != null) {
            for (App app : this.getApps(clearCache)) {
                if (!app.bundleIdEquals(bundleId)) continue;
                return app;
            }
        }
        return null;
    }

    @Override
    public Organization getOrg(String apiKey) throws IOException, AuthenticationException {
        if (apiKey != null) {
            for (Organization org : this.getOrgs(false)) {
                if (!apiKey.equals(org.getApiKey())) continue;
                return org;
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getEnrollments(Organization org) throws IOException, AuthenticationException {
        String url = this._baseApiUrl + "/api/v2/organizations/" + org.getId() + "/enrollments";
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept", "application/json");
        Optional responseJson = RestfulWebApi.jsonFromResponse(this.request(get));
        return new EnrollmentsJsonTransform().createEnrollmentsFrom((JSONObject)((JSONObject)responseJson.get()).get("enrollments"));
    }

    @Override
    public Optional<List<TwitterApp>> getTwitterApps() throws AuthenticationException {
        String uriStr = this.getBaseApiUrl() + "/api/v3/twitter_client_apps";
        try {
            return this.getJSON(new URI(uriStr)).transform(new Function<JSONAware, List<TwitterApp>>(){

                @Override
                public List<TwitterApp> apply(JSONAware input) {
                    return (List)new Gson().fromJson(input.toJSONString(), new TypeToken<List<TwitterApp>>(){}.getType());
                }
            });
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse Twitter App. ", e);
        }
        return Optional.absent();
    }

    @Override
    public Optional<TwitterAppDetail> getTwitterAppDetail(TwitterApp app) throws AuthenticationException {
        String uriStr = this.getBaseApiUrl() + "/api/v3/twitter_client_apps/" + app.id;
        try {
            return this.getJSON(new URI(uriStr)).transform(new Function<JSONAware, TwitterAppDetail>(){

                @Override
                public TwitterAppDetail apply(JSONAware input) {
                    return new Gson().fromJson(input.toJSONString(), TwitterAppDetail.class);
                }
            });
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("Crashlytics encountered a bad URI: " + uriStr, e);
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse Twitter App. ", e);
        }
        return Optional.absent();
    }
}

