/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ApiUtils;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.reloc.org.json.simple.JSONArray;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReleaseSummariesJsonTransform {
    private static final String EXTERNAL_ID = "external_id";
    private static final String INSTANCE_IDENTIFIER = "instance_identifier";
    private static final String TESTER_COUNT = "tester_count";
    private static final String TESTER_WITH_INSTALL_COUNT = "tester_with_install_count";
    private static final String OPEN_INVITATION_COUNT = "open_invitation_count";
    private static final String DISTRIBUTED_AT = "distributed_at";
    private static final String RECEIVED_AT = "received_at";
    private static final String LAST_ACTIVITY_AT = "last_activity_at";
    private static final String DISPLAY_VERSION = "display_version";
    private static final String BUILD_VERSION = "build_version";
    private static final String ACCESS_ENABLED_FROM = "access_enabled_from";

    public List<ReleaseSummary> createReleaseSummariesFrom(JSONObject jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        ArrayList<ReleaseSummary> releaseSummaries = new ArrayList<ReleaseSummary>();
        for (Object key : jsonObj.keySet()) {
            JSONArray releaseSummariesJson = (JSONArray)jsonObj.get(key);
            for (Object releaseSummaryObj : releaseSummariesJson) {
                releaseSummaries.add(this.createListReleaseSummaryFrom((JSONObject)releaseSummaryObj));
            }
        }
        return releaseSummaries;
    }

    public ReleaseSummary createListReleaseSummaryFrom(JSONObject jsonObj) {
        String externalId = (String)jsonObj.get(EXTERNAL_ID);
        String instanceIdentifier = (String)jsonObj.get(INSTANCE_IDENTIFIER);
        long testerCount = (Long)jsonObj.get(TESTER_COUNT);
        long openInvitationCount = (Long)jsonObj.get(OPEN_INVITATION_COUNT);
        Date receivedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObj.get(RECEIVED_AT));
        Date lastActivityAt = ApiUtils.dateFromEpochSeconds((Long)jsonObj.get(LAST_ACTIVITY_AT));
        JSONObject versionJson = (JSONObject)jsonObj.get(BUILD_VERSION);
        String displayVersion = (String)versionJson.get(DISPLAY_VERSION);
        String buildVersion = (String)versionJson.get(BUILD_VERSION);
        return new ReleaseSummary(externalId, instanceIdentifier, testerCount, openInvitationCount, receivedAt, lastActivityAt, displayVersion, buildVersion);
    }

    public ReleaseSummary createSingleReleaseSummaryFrom(JSONObject jsonObj) {
        String instanceIdentifier = (String)jsonObj.get(INSTANCE_IDENTIFIER);
        long testerCount = (Long)jsonObj.get(TESTER_COUNT);
        long testerWithInstallCount = (Long)jsonObj.get(TESTER_WITH_INSTALL_COUNT);
        long openInvitationCount = (Long)jsonObj.get(OPEN_INVITATION_COUNT);
        Date distributedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObj.get(DISTRIBUTED_AT));
        String displayVersion = (String)jsonObj.get(DISPLAY_VERSION);
        String buildVersion = (String)jsonObj.get(BUILD_VERSION);
        return new ReleaseSummary(instanceIdentifier, testerCount, testerWithInstallCount, openInvitationCount, distributedAt, displayVersion, buildVersion);
    }

    public ReleaseSummary createAccessReleaseSummaryFrom(JSONObject jsonObj) {
        String instanceIdentifier = (String)jsonObj.get(INSTANCE_IDENTIFIER);
        Date distributedAt = ApiUtils.dateFromEpochSeconds((Long)jsonObj.get(DISTRIBUTED_AT));
        String displayVersion = (String)jsonObj.get(DISPLAY_VERSION);
        String buildVersion = (String)jsonObj.get(BUILD_VERSION);
        String accessEnabledFrom = (String)jsonObj.get(ACCESS_ENABLED_FROM);
        return new ReleaseSummary(instanceIdentifier, distributedAt, displayVersion, buildVersion, accessEnabledFrom);
    }
}

