/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.xml;

import com.crashlytics.reloc.com.android.io.IAbstractFile;
import com.crashlytics.reloc.com.android.io.IAbstractFolder;
import com.crashlytics.reloc.com.android.io.StreamException;
import com.crashlytics.reloc.com.android.resources.Keyboard;
import com.crashlytics.reloc.com.android.resources.Navigation;
import com.crashlytics.reloc.com.android.resources.TouchScreen;
import com.crashlytics.reloc.com.android.sdklib.xml.AndroidManifest;
import com.crashlytics.reloc.com.android.sdklib.xml.ManifestData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AndroidManifestParser {
    private static final int LEVEL_TOP = 0;
    private static final int LEVEL_INSIDE_MANIFEST = 1;
    private static final int LEVEL_INSIDE_APPLICATION = 2;
    private static final int LEVEL_INSIDE_APP_COMPONENT = 3;
    private static final int LEVEL_INSIDE_INTENT_FILTER = 4;
    private static final String ACTION_MAIN = "android.intent.action.MAIN";
    private static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();

    public static ManifestData parse(IAbstractFile iAbstractFile, boolean bl, ManifestErrorHandler manifestErrorHandler) throws SAXException, IOException, StreamException, ParserConfigurationException {
        if (iAbstractFile != null) {
            SAXParser sAXParser = sParserFactory.newSAXParser();
            ManifestData manifestData = null;
            if (bl) {
                manifestData = new ManifestData();
            }
            ManifestHandler manifestHandler = new ManifestHandler(iAbstractFile, manifestData, manifestErrorHandler);
            sAXParser.parse(new InputSource(iAbstractFile.getContents()), (DefaultHandler)manifestHandler);
            return manifestData;
        }
        return null;
    }

    public static ManifestData parse(IAbstractFile iAbstractFile) throws SAXException, IOException, StreamException, ParserConfigurationException {
        return AndroidManifestParser.parse(iAbstractFile, true, null);
    }

    public static ManifestData parse(IAbstractFolder iAbstractFolder) throws SAXException, IOException, StreamException, ParserConfigurationException {
        IAbstractFile iAbstractFile = AndroidManifest.getManifest(iAbstractFolder);
        if (iAbstractFile == null) {
            throw new FileNotFoundException();
        }
        return AndroidManifestParser.parse(iAbstractFile, true, null);
    }

    public static ManifestData parse(InputStream inputStream) throws SAXException, IOException, StreamException, ParserConfigurationException {
        if (inputStream != null) {
            SAXParser sAXParser = sParserFactory.newSAXParser();
            ManifestData manifestData = new ManifestData();
            ManifestHandler manifestHandler = new ManifestHandler(null, manifestData, null);
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)manifestHandler);
            return manifestData;
        }
        return null;
    }

    static {
        sParserFactory.setNamespaceAware(true);
    }

    private static class ManifestHandler
    extends DefaultHandler {
        private final ManifestData mManifestData;
        private final ManifestErrorHandler mErrorHandler;
        private int mCurrentLevel = 0;
        private int mValidLevel = 0;
        private ManifestData.Activity mCurrentActivity = null;
        private Locator mLocator;

        ManifestHandler(IAbstractFile iAbstractFile, ManifestData manifestData, ManifestErrorHandler manifestErrorHandler) {
            this.mManifestData = manifestData;
            this.mErrorHandler = manifestErrorHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.mLocator = locator;
            super.setDocumentLocator(locator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (this.mManifestData == null) {
                    return;
                }
                if (this.mValidLevel == this.mCurrentLevel) {
                    switch (this.mValidLevel) {
                        case 0: {
                            if (!"manifest".equals(string2)) break;
                            this.mManifestData.mPackage = this.getAttributeValue(attributes, "package", false);
                            String string4 = this.getAttributeValue(attributes, "versionCode", true);
                            if (string4 != null) {
                                try {
                                    this.mManifestData.mVersionCode = Integer.valueOf(string4);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++this.mValidLevel;
                            break;
                        }
                        case 1: {
                            Boolean bl;
                            if ("application".equals(string2)) {
                                String string5 = this.getAttributeValue(attributes, "process", true);
                                if (string5 != null) {
                                    this.mManifestData.addProcessName(string5);
                                }
                                if ((string5 = this.getAttributeValue(attributes, "debuggable", true)) != null) {
                                    this.mManifestData.mDebuggable = Boolean.parseBoolean(string5);
                                }
                                ++this.mValidLevel;
                                break;
                            }
                            if ("uses-sdk".equals(string2)) {
                                this.mManifestData.setMinSdkVersionString(this.getAttributeValue(attributes, "minSdkVersion", true));
                                this.mManifestData.setTargetSdkVersionString(this.getAttributeValue(attributes, "targetSdkVersion", true));
                                break;
                            }
                            if ("instrumentation".equals(string2)) {
                                this.processInstrumentationNode(attributes);
                                break;
                            }
                            if ("supports-screens".equals(string2)) {
                                this.processSupportsScreensNode(attributes);
                                break;
                            }
                            if ("uses-configuration".equals(string2)) {
                                this.processUsesConfiguration(attributes);
                                break;
                            }
                            if (!"uses-feature".equals(string2)) break;
                            ManifestData.UsesFeature usesFeature = new ManifestData.UsesFeature();
                            String string6 = this.getAttributeValue(attributes, "name", true);
                            if (string6 != null) {
                                usesFeature.mName = string6;
                            }
                            if ((string6 = this.getAttributeValue(attributes, "required", true)) != null && (bl = Boolean.valueOf(string6)) != null) {
                                usesFeature.mRequired = bl;
                            }
                            if ((string6 = this.getAttributeValue(attributes, "glEsVersion", true)) != null) {
                                try {
                                    int n;
                                    usesFeature.mGlEsVersion = n = Integer.decode(string6).intValue();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            this.mManifestData.mFeatures.add(usesFeature);
                            break;
                        }
                        case 2: {
                            Boolean bl;
                            String string7;
                            if ("activity".equals(string2)) {
                                this.processActivityNode(attributes);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("service".equals(string2)) {
                                this.processNode(attributes, "android.app.Service");
                                ++this.mValidLevel;
                                break;
                            }
                            if ("receiver".equals(string2)) {
                                this.processNode(attributes, "android.content.BroadcastReceiver");
                                ++this.mValidLevel;
                                break;
                            }
                            if ("provider".equals(string2)) {
                                this.processNode(attributes, "android.content.ContentProvider");
                                ++this.mValidLevel;
                                break;
                            }
                            if (!"uses-library".equals(string2) || (string7 = this.getAttributeValue(attributes, "name", true)) == null) break;
                            ManifestData.UsesLibrary usesLibrary = new ManifestData.UsesLibrary();
                            usesLibrary.mName = string7;
                            string7 = this.getAttributeValue(attributes, "required", true);
                            if (string7 != null && (bl = Boolean.valueOf(string7)) != null) {
                                usesLibrary.mRequired = bl;
                            }
                            this.mManifestData.mLibraries.add(usesLibrary);
                            break;
                        }
                        case 3: {
                            if (this.mCurrentActivity == null || !"intent-filter".equals(string2)) break;
                            this.mCurrentActivity.resetIntentFilter();
                            ++this.mValidLevel;
                            break;
                        }
                        case 4: {
                            String string8;
                            if (this.mCurrentActivity == null) break;
                            if ("action".equals(string2)) {
                                String string9 = this.getAttributeValue(attributes, "name", true);
                                if (string9 == null) break;
                                this.mCurrentActivity.setHasAction(true);
                                this.mCurrentActivity.setHasMainAction(AndroidManifestParser.ACTION_MAIN.equals(string9));
                                break;
                            }
                            if (!"category".equals(string2) || !AndroidManifestParser.CATEGORY_LAUNCHER.equals(string8 = this.getAttributeValue(attributes, "name", true))) break;
                            this.mCurrentActivity.setHasLauncherCategory(true);
                        }
                    }
                }
                ++this.mCurrentLevel;
            }
            finally {
                super.startElement(string, string2, string3, attributes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                if (this.mManifestData == null) {
                    return;
                }
                if (this.mValidLevel == this.mCurrentLevel) {
                    --this.mValidLevel;
                }
                --this.mCurrentLevel;
                if (this.mValidLevel != this.mCurrentLevel) return;
                switch (this.mValidLevel) {
                    case 2: {
                        this.mCurrentActivity = null;
                        return;
                    }
                    case 3: {
                        if (this.mManifestData.mLauncherActivity != null) return;
                        if (this.mCurrentActivity == null) return;
                        if (!this.mCurrentActivity.isHomeActivity()) return;
                        if (!this.mCurrentActivity.isExported()) return;
                        this.mManifestData.mLauncherActivity = this.mCurrentActivity;
                        return;
                    }
                }
                return;
            }
            finally {
                super.endElement(string, string2, string3);
            }
        }

        public void error(SAXParseException sAXParseException) {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.handleError(sAXParseException, sAXParseException.getLineNumber());
            }
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.handleError(sAXParseException, sAXParseException.getLineNumber());
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.warning(sAXParseException);
            }
        }

        private void processActivityNode(Attributes attributes) {
            String string;
            String string2 = this.getAttributeValue(attributes, "name", true);
            if (string2 != null) {
                string2 = AndroidManifest.combinePackageAndClassName(this.mManifestData.mPackage, string2);
                string = this.getAttributeValue(attributes, "exported", true);
                boolean bl = string == null || string.toLowerCase(Locale.US).equals("true");
                this.mCurrentActivity = new ManifestData.Activity(string2, bl);
                this.mManifestData.mActivities.add(this.mCurrentActivity);
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, string2, "android.app.Activity", true);
                }
            } else {
                this.mCurrentActivity = null;
            }
            string = this.getAttributeValue(attributes, "process", true);
            if (string != null) {
                this.mManifestData.addProcessName(string);
            }
        }

        private void processNode(Attributes attributes, String string) {
            String string2;
            String string3 = this.getAttributeValue(attributes, "name", true);
            if (string3 != null) {
                string3 = AndroidManifest.combinePackageAndClassName(this.mManifestData.mPackage, string3);
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, string3, string, false);
                }
            }
            if ((string2 = this.getAttributeValue(attributes, "process", true)) != null) {
                this.mManifestData.addProcessName(string2);
            }
        }

        private void processInstrumentationNode(Attributes attributes) {
            String string = this.getAttributeValue(attributes, "name", true);
            if (string != null) {
                String string2 = AndroidManifest.combinePackageAndClassName(this.mManifestData.mPackage, string);
                String string3 = this.getAttributeValue(attributes, "targetPackage", true);
                this.mManifestData.mInstrumentations.add(new ManifestData.Instrumentation(string2, string3));
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, string2, "android.app.Instrumentation", true);
                }
            }
        }

        private void processSupportsScreensNode(Attributes attributes) {
            this.mManifestData.mSupportsScreensFromManifest = new ManifestData.SupportsScreens();
            this.mManifestData.mSupportsScreensFromManifest.setResizeable(this.getAttributeBooleanValue(attributes, "resizeable", true));
            this.mManifestData.mSupportsScreensFromManifest.setAnyDensity(this.getAttributeBooleanValue(attributes, "anyDensity", true));
            this.mManifestData.mSupportsScreensFromManifest.setSmallScreens(this.getAttributeBooleanValue(attributes, "smallScreens", true));
            this.mManifestData.mSupportsScreensFromManifest.setNormalScreens(this.getAttributeBooleanValue(attributes, "normalScreens", true));
            this.mManifestData.mSupportsScreensFromManifest.setLargeScreens(this.getAttributeBooleanValue(attributes, "largeScreens", true));
        }

        private void processUsesConfiguration(Attributes attributes) {
            this.mManifestData.mUsesConfiguration = new ManifestData.UsesConfiguration();
            this.mManifestData.mUsesConfiguration.mReqFiveWayNav = this.getAttributeBooleanValue(attributes, "reqFiveWayNav", true);
            this.mManifestData.mUsesConfiguration.mReqNavigation = Navigation.getEnum(this.getAttributeValue(attributes, "reqNavigation", true));
            this.mManifestData.mUsesConfiguration.mReqHardKeyboard = this.getAttributeBooleanValue(attributes, "reqHardKeyboard", true);
            this.mManifestData.mUsesConfiguration.mReqKeyboardType = Keyboard.getEnum(this.getAttributeValue(attributes, "reqKeyboardType", true));
            this.mManifestData.mUsesConfiguration.mReqTouchScreen = TouchScreen.getEnum(this.getAttributeValue(attributes, "reqTouchScreen", true));
        }

        private String getAttributeValue(Attributes attributes, String string, boolean bl) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(attributes.getLocalName(i)) || (!bl || !"http://schemas.android.com/apk/res/android".equals(attributes.getURI(i))) && (bl || attributes.getURI(i).length() != 0)) continue;
                return attributes.getValue(i);
            }
            return null;
        }

        private Boolean getAttributeBooleanValue(Attributes attributes, String string, boolean bl) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(attributes.getLocalName(i)) || (!bl || !"http://schemas.android.com/apk/res/android".equals(attributes.getURI(i))) && (bl || attributes.getURI(i).length() != 0)) continue;
                String string2 = attributes.getValue(i);
                if (string2 != null) {
                    return Boolean.valueOf(string2);
                }
                return null;
            }
            return null;
        }
    }

    public static interface ManifestErrorHandler
    extends ErrorHandler {
        public void handleError(Exception var1, int var2);

        public void checkClass(Locator var1, String var2, String var3, boolean var4);
    }
}

