/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileCode
implements Code {
    private StringBuffer _codeBuffer;
    private int _minimumChangeAllowedAt;
    private int _currentOffset;
    private File _targetFile;

    public FileCode(File targetFile) {
        this._targetFile = targetFile;
        this._codeBuffer = null;
        this._minimumChangeAllowedAt = 0;
        this._currentOffset = 0;
    }

    @Override
    public String getCode() {
        try {
            return FileUtils.fileToString(this._targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Crashlytics could not convert file to string.");
        }
    }

    @Override
    public void delete(int start, int numCharsDeleting) {
        DeveloperTools.logD("deleting from" + start + " to " + numCharsDeleting + start);
        if (start < this._minimumChangeAllowedAt) {
            throw new RuntimeException("Code can only be manipulated in increasing order.");
        }
        this._codeBuffer.delete(start + this._currentOffset, start + numCharsDeleting + this._currentOffset);
        this._minimumChangeAllowedAt = start;
        this._currentOffset -= numCharsDeleting;
    }

    @Override
    public void insert(int start, String text) {
        DeveloperTools.logD("inserting at" + start + " the text:" + text);
        if (start < this._minimumChangeAllowedAt) {
            throw new RuntimeException("Code can only be manipulated in increasing order.");
        }
        this._codeBuffer.insert(start + this._currentOffset, text);
        int numCharsAdded = text.length();
        this._minimumChangeAllowedAt = start;
        this._currentOffset += numCharsAdded;
    }

    @Override
    public void start() {
        try {
            this._codeBuffer = new StringBuffer(FileUtils.fileToString(this._targetFile));
        }
        catch (IOException e) {
            throw new RuntimeException("File not found", e);
        }
        this._minimumChangeAllowedAt = 0;
        this._currentOffset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this._targetFile);
            writer.write(this._codeBuffer.toString());
        }
        catch (IOException e) {
            try {
                DeveloperTools.logE("Crashlytics could not write to file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }
        IOUtils.closeQuietly(writer);
    }
}

