/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class TwitterAuthCodeBlockFactory {
    private static String DEFAULT_KEY = "TWITTER_KEY";
    private static String DEFAULT_SECRET = "TWITTER_SECRET";

    public static Collection<? extends String> getImports() {
        LinkedList<String> importStrings = new LinkedList<String>();
        importStrings.add("com.twitter.sdk.android.identity.TwitterAuthClient");
        importStrings.add("com.twitter.sdk.android.identity.TwitterLoginButton");
        importStrings.add("com.twitter.sdk.android.services.twitternetwork.TwitterAuthConfig");
        importStrings.add("com.twitter.sdk.android.services.twitternetwork.TwitterAuthException");
        importStrings.add("com.twitter.sdk.android.services.twitternetwork.TwitterAuthResponse");
        importStrings.add("android.content.Intent");
        importStrings.add("android.widget.Toast");
        return importStrings;
    }

    public static String getVariableDeclarationCode(String tab, String key, String secret) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "private static final int REQUEST_CODE_LOGIN = 1;\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "private static final String TWITTER_KEY = \"" + key + "\";\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "private static final String TWITTER_SECRET = \"" + secret + "\";\n"));
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "private TwitterAuthConfig mAuthConfig;\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "private TwitterLoginButton mLoginButton;"));
        return builder.toString();
    }

    public static String getLayoutManipulationCode(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "mAuthConfig = new TwitterAuthConfig(TWITTER_KEY, TWITTER_SECRET);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "mLoginButton = (TwitterLoginButton) findViewById(R.id.login_button);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "mLoginButton.setAuthClient(new TwitterAuthClient(this, mAuthConfig) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "public void onAuthSuccess(TwitterAuthResponse response) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(4, tab, "Toast.makeText(MainActivity.this, \"Authentication succeeded\", Toast.LENGTH_SHORT).show();\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "}\n"));
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "public void onAuthError(TwitterAuthException response) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(4, tab, "Toast.makeText(MainActivity.this, \"Authentication failed\", Toast.LENGTH_SHORT).show();\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "}\n"));
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "public int getRequestCode() {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(4, tab, "return REQUEST_CODE_LOGIN;\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "}\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "});"));
        return builder.toString();
    }

    public static String getExtraMethods(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "protected void onActivityResult(int requestCode, int resultCode, Intent data) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "super.onActivityResult(requestCode, resultCode, data);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "mLoginButton.onActivityResult(requestCode, resultCode, data);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "}\n"));
        return builder.toString();
    }

    public static String getVariableDeclarationCode(String tab) {
        return TwitterAuthCodeBlockFactory.getVariableDeclarationCode(tab, DEFAULT_KEY, DEFAULT_SECRET);
    }

    public static CodeChange getManualClassDirections(String javaFileContents, String key, String secret) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        Joiner joiner = Joiner.on("\n");
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("import android.app.Activity;", javaFileContents, TwitterAuthCodeBlockFactory.createImports(TwitterAuthCodeBlockFactory.getImports())));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("public class MainActivity extends Activity {", javaFileContents, TwitterAuthCodeBlockFactory.getVariableDeclarationCode("\t", key, secret)));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);", javaFileContents, TwitterAuthCodeBlockFactory.getLayoutManipulationCode("\t")));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);\n  }", javaFileContents, TwitterAuthCodeBlockFactory.getExtraMethods("\t")));
        return new CodeChange("View Class", new StubCode(javaFileContents), changes);
    }

    private static String createImports(Collection<? extends String> imports) {
        StringBuilder builder = new StringBuilder();
        for (String string : imports) {
            builder.append("import " + string + ";\n");
        }
        return builder.toString();
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length() + 1, toAdd);
    }

    public static String getLoginButton(String newlineIdented) {
        Joiner joiner = Joiner.on(newlineIdented);
        return joiner.join("    <com.twitter.sdk.android.identity.TwitterLoginButton", "android:id=\"@+id/login_button\"", "android:layout_width=\"wrap_content\"", "android:layout_height=\"wrap_content\"", "android:layout_centerInParent=\"true\"/>");
    }

    public static CodeChange getManualViewDirections(String viewFileContents) {
        String layoutElementcontent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterAuthCodeBlockFactory.injectAfter(layoutElementcontent, viewFileContents, TwitterAuthCodeBlockFactory.getLoginButton("\n        "))));
    }

    private static String indentString(int tabs, String tab, String string) {
        return Strings.repeat(tab, tabs) + string;
    }
}

