/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.build;

import com.crashlytics.reloc.com.android.sdklib.build.ApkCreationException;
import com.crashlytics.reloc.com.android.sdklib.build.DuplicateFileException;
import com.crashlytics.reloc.com.android.sdklib.build.IArchiveBuilder;
import com.crashlytics.reloc.com.android.sdklib.build.SealedApkException;
import com.crashlytics.reloc.com.android.sdklib.internal.build.DebugKeyProvider;
import com.crashlytics.reloc.com.android.sdklib.internal.build.SignedJarBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApkBuilder
implements IArchiveBuilder {
    private static final Pattern PATTERN_NATIVELIB_EXT = Pattern.compile("^.+\\.so$", 2);
    private File mApkFile;
    private File mResFile;
    private File mDexFile;
    private PrintStream mVerboseStream;
    private SignedJarBuilder mBuilder;
    private boolean mDebugMode = false;
    private boolean mIsSealed = false;
    private final NullZipFilter mNullFilter = new NullZipFilter();
    private final JavaAndNativeResourceFilter mFilter = new JavaAndNativeResourceFilter();
    private final HashMap<String, File> mAddedFiles = new HashMap();

    public static SigningInfo getDebugKey(String string, final PrintStream printStream) throws ApkCreationException {
        try {
            if (string != null) {
                File file = new File(string);
                try {
                    ApkBuilder.checkInputFile(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (printStream != null) {
                    printStream.println(String.format("Using keystore: %s", string));
                }
                DebugKeyProvider.IKeyGenOutput iKeyGenOutput = null;
                if (printStream != null) {
                    iKeyGenOutput = new DebugKeyProvider.IKeyGenOutput(){

                        public void out(String string) {
                            printStream.println(string);
                        }

                        public void err(String string) {
                            printStream.println(string);
                        }
                    };
                }
                DebugKeyProvider debugKeyProvider = new DebugKeyProvider(string, null, iKeyGenOutput);
                PrivateKey privateKey = debugKeyProvider.getDebugKey();
                X509Certificate x509Certificate = (X509Certificate)debugKeyProvider.getCertificate();
                if (privateKey == null) {
                    throw new ApkCreationException("Unable to get debug signature key", new Object[0]);
                }
                if (x509Certificate != null && x509Certificate.getNotAfter().compareTo(new Date()) < 0) {
                    throw new ApkCreationException("Debug Certificate expired on " + DateFormat.getInstance().format(x509Certificate.getNotAfter()), new Object[0]);
                }
                return new SigningInfo(privateKey, x509Certificate);
            }
            return null;
        }
        catch (DebugKeyProvider.KeytoolException keytoolException) {
            if (keytoolException.getJavaHome() == null) {
                throw new ApkCreationException(keytoolException.getMessage() + "\nJAVA_HOME seems undefined, setting it will help locating keytool automatically\n" + "You can also manually execute the following command\n:" + keytoolException.getCommandLine(), new Object[]{keytoolException});
            }
            throw new ApkCreationException(keytoolException.getMessage() + "\nJAVA_HOME is set to: " + keytoolException.getJavaHome() + "\nUpdate it if necessary, or manually execute the following command:\n" + keytoolException.getCommandLine(), new Object[]{keytoolException});
        }
        catch (ApkCreationException apkCreationException) {
            throw apkCreationException;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception);
        }
    }

    public ApkBuilder(String string, String string2, String string3, String string4, PrintStream printStream) throws ApkCreationException {
        this(new File(string), new File(string2), string3 != null ? new File(string3) : null, string4, printStream);
    }

    public ApkBuilder(String string, String string2, String string3, PrivateKey privateKey, X509Certificate x509Certificate, PrintStream printStream) throws ApkCreationException {
        this(new File(string), new File(string2), string3 != null ? new File(string3) : null, privateKey, x509Certificate, printStream);
    }

    public ApkBuilder(File file, File file2, File file3, String string, PrintStream printStream) throws ApkCreationException {
        SigningInfo signingInfo = ApkBuilder.getDebugKey(string, printStream);
        if (signingInfo != null) {
            this.init(file, file2, file3, signingInfo.key, signingInfo.certificate, printStream);
        } else {
            this.init(file, file2, file3, null, null, printStream);
        }
    }

    public ApkBuilder(File file, File file2, File file3, PrivateKey privateKey, X509Certificate x509Certificate, PrintStream printStream) throws ApkCreationException {
        this.init(file, file2, file3, privateKey, x509Certificate, printStream);
    }

    private void init(File file, File file2, File file3, PrivateKey privateKey, X509Certificate x509Certificate, PrintStream printStream) throws ApkCreationException {
        try {
            this.mApkFile = file;
            this.checkOutputFile(this.mApkFile);
            this.mResFile = file2;
            ApkBuilder.checkInputFile(this.mResFile);
            if (file3 != null) {
                this.mDexFile = file3;
                ApkBuilder.checkInputFile(this.mDexFile);
            } else {
                this.mDexFile = null;
            }
            this.mVerboseStream = printStream;
            this.mBuilder = new SignedJarBuilder(new FileOutputStream(this.mApkFile, false), privateKey, x509Certificate);
            this.verbosePrintln("Packaging %s", this.mApkFile.getName());
            this.addZipFile(this.mResFile);
            if (this.mDexFile != null) {
                this.addFile(this.mDexFile, "classes.dex");
            }
        }
        catch (ApkCreationException apkCreationException) {
            throw apkCreationException;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception);
        }
    }

    public void setDebugMode(boolean bl) {
        this.mDebugMode = bl;
    }

    @Override
    public void addFile(File file, String string) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.doAddFile(file, string);
        }
        catch (DuplicateFileException duplicateFileException) {
            throw duplicateFileException;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception, "Failed to add %s", file);
        }
    }

    public void addZipFile(File file) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.verbosePrintln("%s:", file);
            this.mNullFilter.reset(file);
            FileInputStream fileInputStream = new FileInputStream(file);
            this.mBuilder.writeZip(fileInputStream, this.mNullFilter);
        }
        catch (DuplicateFileException duplicateFileException) {
            throw duplicateFileException;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception, "Failed to add %s", file);
        }
    }

    public JarStatus addResourcesFromJar(File file) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.verbosePrintln("%s:", file);
            this.mFilter.reset(file);
            FileInputStream fileInputStream = new FileInputStream(file);
            this.mBuilder.writeZip(fileInputStream, this.mFilter);
            return new JarStatusImpl(this.mFilter.getNativeLibs(), this.mFilter.getNativeLibsConflict());
        }
        catch (DuplicateFileException duplicateFileException) {
            throw duplicateFileException;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception, "Failed to add %s", file);
        }
    }

    public void addSourceFolder(File file) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        ApkBuilder.addSourceFolder(this, file);
    }

    public static void addSourceFolder(IArchiveBuilder iArchiveBuilder, File file) throws ApkCreationException, DuplicateFileException {
        if (file.isDirectory()) {
            try {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    ApkBuilder.processFileForResource(iArchiveBuilder, file2, null);
                }
            }
            catch (DuplicateFileException duplicateFileException) {
                throw duplicateFileException;
            }
            catch (Exception exception) {
                throw new ApkCreationException(exception, "Failed to add %s", file);
            }
        } else {
            if (file.exists()) {
                throw new ApkCreationException("%s is not a folder", file);
            }
            throw new ApkCreationException("%s does not exist", file);
        }
    }

    public void addNativeLibraries(File file) throws ApkCreationException, SealedApkException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new ApkCreationException("%s is not a folder", file);
            }
            throw new ApkCreationException("%s does not exist", file);
        }
        File[] fileArray = file.listFiles();
        this.verbosePrintln("Native folder: %s", file);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File[] fileArray2;
                if (!file2.isDirectory() || (fileArray2 = file2.listFiles()) == null) continue;
                for (File file3 : fileArray2) {
                    if (!file3.isFile() || !PATTERN_NATIVELIB_EXT.matcher(file3.getName()).matches() && (!this.mDebugMode || !"gdbserver".equals(file3.getName()))) continue;
                    String string = "lib/" + file2.getName() + "/" + file3.getName();
                    try {
                        this.doAddFile(file3, string);
                    }
                    catch (IOException iOException) {
                        throw new ApkCreationException(iOException, "Failed to add %s", file3);
                    }
                }
            }
        }
    }

    public void addNativeLibraries(List<FileEntry> list) throws SealedApkException, DuplicateFileException, ApkCreationException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        for (FileEntry fileEntry : list) {
            try {
                this.doAddFile(fileEntry.mFile, fileEntry.mPath);
            }
            catch (IOException iOException) {
                throw new ApkCreationException(iOException, "Failed to add %s", fileEntry.mFile);
            }
        }
    }

    public static List<FileEntry> getNativeFiles(File file, boolean bl) throws ApkCreationException {
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new ApkCreationException("%s is not a folder", file);
            }
            throw new ApkCreationException("%s does not exist", file);
        }
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File[] fileArray2;
                if (!file2.isDirectory() || (fileArray2 = file2.listFiles()) == null) continue;
                for (File file3 : fileArray2) {
                    if (!file3.isFile() || !PATTERN_NATIVELIB_EXT.matcher(file3.getName()).matches() && (!bl || !"gdbserver".equals(file3.getName()))) continue;
                    String string = "lib/" + file2.getName() + "/" + file3.getName();
                    arrayList.add(new FileEntry(file3, string));
                }
            }
        }
        return arrayList;
    }

    public void sealApk() throws ApkCreationException, SealedApkException {
        if (this.mIsSealed) {
            throw new SealedApkException("APK is already sealed", new Object[0]);
        }
        try {
            this.mBuilder.close();
            this.mIsSealed = true;
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception, "Failed to seal APK", new Object[0]);
        }
    }

    private void verbosePrintln(String string, Object ... objectArray) {
        if (this.mVerboseStream != null) {
            this.mVerboseStream.println(String.format(string, objectArray));
        }
    }

    private void doAddFile(File file, String string) throws DuplicateFileException, IOException {
        this.verbosePrintln("%1$s => %2$s", file, string);
        File file2 = this.checkFileForDuplicate(string);
        if (file2 != null) {
            throw new DuplicateFileException(string, file2, file);
        }
        this.mAddedFiles.put(string, file);
        this.mBuilder.writeFile(file, string);
    }

    private static void processFileForResource(IArchiveBuilder iArchiveBuilder, File file, String string) throws IOException, DuplicateFileException, ApkCreationException, SealedApkException {
        if (file.isDirectory()) {
            if (ApkBuilder.checkFolderForPackaging(file.getName())) {
                File[] fileArray;
                string = string == null ? file.getName() : string + "/" + file.getName();
                for (File file2 : fileArray = file.listFiles()) {
                    ApkBuilder.processFileForResource(iArchiveBuilder, file2, string);
                }
            }
        } else if (ApkBuilder.checkFileForPackaging(file.getName())) {
            string = string == null ? file.getName() : string + "/" + file.getName();
            iArchiveBuilder.addFile(file, string);
        }
    }

    private File checkFileForDuplicate(String string) {
        return this.mAddedFiles.get(string);
    }

    private void checkOutputFile(File file) throws ApkCreationException {
        if (file.isDirectory()) {
            throw new ApkCreationException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new ApkCreationException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new ApkCreationException("Failed to create %s", file);
                }
            }
            catch (IOException iOException) {
                throw new ApkCreationException("Failed to create '%1$ss': %2$s", file, iOException.getMessage());
            }
        }
    }

    private static void checkInputFile(File file) throws FileNotFoundException, ApkCreationException {
        if (file.isDirectory()) {
            throw new ApkCreationException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new ApkCreationException("Cannot read %s", file);
            }
        } else {
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
    }

    public static String getDebugKeystore() throws ApkCreationException {
        try {
            return DebugKeyProvider.getDefaultKeyStoreOsPath();
        }
        catch (Exception exception) {
            throw new ApkCreationException(exception, exception.getMessage(), new Object[0]);
        }
    }

    public static boolean checkFolderForPackaging(String string) {
        return !string.equalsIgnoreCase("CVS") && !string.equalsIgnoreCase(".svn") && !string.equalsIgnoreCase("SCCS") && !string.equalsIgnoreCase("META-INF") && !string.startsWith("_");
    }

    public static boolean checkFileForPackaging(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = "";
        if (stringArray.length > 1) {
            string2 = stringArray[stringArray.length - 1];
        }
        return ApkBuilder.checkFileForPackaging(string, string2);
    }

    public static boolean checkFileForPackaging(String string, String string2) {
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '~') {
            return false;
        }
        return !"aidl".equalsIgnoreCase(string2) && !"rs".equalsIgnoreCase(string2) && !"rsh".equalsIgnoreCase(string2) && !"d".equalsIgnoreCase(string2) && !"java".equalsIgnoreCase(string2) && !"scala".equalsIgnoreCase(string2) && !"class".equalsIgnoreCase(string2) && !"scc".equalsIgnoreCase(string2) && !"swp".equalsIgnoreCase(string2) && !"thumbs.db".equalsIgnoreCase(string) && !"picasa.ini".equalsIgnoreCase(string) && !"package.html".equalsIgnoreCase(string) && !"overview.html".equalsIgnoreCase(string);
    }

    public static final class FileEntry {
        public final File mFile;
        public final String mPath;

        FileEntry(File file, String string) {
            this.mFile = file;
            this.mPath = string;
        }
    }

    public static final class SigningInfo {
        public final PrivateKey key;
        public final X509Certificate certificate;

        private SigningInfo(PrivateKey privateKey, X509Certificate x509Certificate) {
            if (privateKey == null || x509Certificate == null) {
                throw new IllegalArgumentException("key and certificate cannot be null");
            }
            this.key = privateKey;
            this.certificate = x509Certificate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JarStatusImpl
    implements JarStatus {
        public final List<String> mLibs;
        public final boolean mNativeLibsConflict;

        private JarStatusImpl(List<String> list, boolean bl) {
            this.mLibs = list;
            this.mNativeLibsConflict = bl;
        }

        @Override
        public List<String> getNativeLibs() {
            return this.mLibs;
        }

        @Override
        public boolean hasNativeLibsConflicts() {
            return this.mNativeLibsConflict;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JarStatus {
        public List<String> getNativeLibs();

        public boolean hasNativeLibsConflicts();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JavaAndNativeResourceFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final List<String> mNativeLibs = new ArrayList<String>();
        private boolean mNativeLibsConflict = false;
        private File mInputFile;

        private JavaAndNativeResourceFilter() {
        }

        @Override
        public boolean checkEntry(String string) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            String[] stringArray = string.split("/");
            if (stringArray.length == 0) {
                return false;
            }
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (ApkBuilder.checkFolderForPackaging(stringArray[i])) continue;
                return false;
            }
            String string2 = stringArray[stringArray.length - 1];
            boolean bl = ApkBuilder.checkFileForPackaging(string2);
            if (bl) {
                ApkBuilder.this.verbosePrintln("=> %s", new Object[]{string});
                File file = ApkBuilder.this.checkFileForDuplicate(string);
                if (file != null) {
                    throw new DuplicateFileException(string, file, this.mInputFile);
                }
                ApkBuilder.this.mAddedFiles.put(string, this.mInputFile);
                if (string.endsWith(".so")) {
                    this.mNativeLibs.add(string);
                    if (string.startsWith("lib/")) {
                        this.mNativeLibsConflict = true;
                    }
                } else if (string.endsWith(".jnilib")) {
                    this.mNativeLibs.add(string);
                }
            }
            return bl;
        }

        List<String> getNativeLibs() {
            return this.mNativeLibs;
        }

        boolean getNativeLibsConflict() {
            return this.mNativeLibsConflict;
        }

        void reset(File file) {
            this.mInputFile = file;
            this.mNativeLibs.clear();
            this.mNativeLibsConflict = false;
        }
    }

    private final class NullZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private File mInputFile;

        private NullZipFilter() {
        }

        void reset(File file) {
            this.mInputFile = file;
        }

        public boolean checkEntry(String string) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            ApkBuilder.this.verbosePrintln("=> %s", new Object[]{string});
            File file = ApkBuilder.this.checkFileForDuplicate(string);
            if (file != null) {
                throw new DuplicateFileException(string, file, this.mInputFile);
            }
            ApkBuilder.this.mAddedFiles.put(string, this.mInputFile);
            return true;
        }
    }
}

