/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.AndroidVersion;
import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IMinApiLevelDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPackageVersion;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.MinToolsPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import com.crashlytics.reloc.com.android.sdklib.io.IFileOp;
import com.crashlytics.reloc.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplePackage
extends MinToolsPackage
implements IPackageVersion,
IMinApiLevelDependency {
    private final AndroidVersion mVersion;
    private final int mMinApiLevel;

    SamplePackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        int n = XmlParserUtils.getXmlInt(node, "api-level", 0);
        String string2 = XmlParserUtils.getXmlString(node, "codename");
        if (string2.length() == 0) {
            string2 = null;
        }
        this.mVersion = new AndroidVersion(n, string2);
        this.mMinApiLevel = XmlParserUtils.getXmlInt(node, "min-api-level", 0);
    }

    static Package create(IAndroidTarget iAndroidTarget, Properties properties) {
        return new SamplePackage(iAndroidTarget, properties);
    }

    private SamplePackage(IAndroidTarget iAndroidTarget, Properties properties) {
        super(null, properties, 0, null, null, null, Archive.Os.ANY, Archive.Arch.ANY, iAndroidTarget.getPath(4));
        this.mVersion = iAndroidTarget.getVersion();
        this.mMinApiLevel = Integer.parseInt(SamplePackage.getProperty(properties, "Sample.MinApiLevel", Integer.toString(0)));
    }

    static Package create(String string, Properties properties) throws AndroidVersion.AndroidVersionException {
        return new SamplePackage(string, properties);
    }

    private SamplePackage(String string, Properties properties) throws AndroidVersion.AndroidVersionException {
        super(null, properties, 0, null, null, null, Archive.Os.ANY, Archive.Arch.ANY, string);
        this.mVersion = new AndroidVersion(properties);
        this.mMinApiLevel = Integer.parseInt(SamplePackage.getProperty(properties, "Sample.MinApiLevel", Integer.toString(0)));
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        this.mVersion.saveProperties(properties);
        if (this.getMinApiLevel() != 0) {
            properties.setProperty("Sample.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "sample-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        String string = String.format("Samples for SDK API %1$s%2$s%3$s", this.mVersion.getApiString(), this.mVersion.isPreview() ? " Preview" : "", this.isObsolete() ? " (Obsolete)" : "");
        return string;
    }

    @Override
    public String getShortDescription() {
        String string = String.format("Samples for SDK API %1$s%2$s, revision %3$d%4$s", this.mVersion.getApiString(), this.mVersion.isPreview() ? " Preview" : "", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        return string;
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        File file = new File(string, "samples");
        for (IAndroidTarget iAndroidTarget : sdkManager.getTargets()) {
            String string2;
            File file2;
            if (!iAndroidTarget.isPlatform() || !iAndroidTarget.getVersion().equals(this.mVersion) || !(file2 = new File(string2 = iAndroidTarget.getPath(4))).isDirectory() || !file2.getParentFile().equals(file)) continue;
            return file2;
        }
        Object object = new File(file, String.format("android-%s", this.getVersion().getApiString()));
        int n = 1;
        while (((File)object).exists()) {
            object = new File(file, String.format("android-%s_%d", this.getVersion().getApiString(), n));
            ++n;
        }
        return object;
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof SamplePackage) {
            SamplePackage samplePackage = (SamplePackage)package_;
            return samplePackage.getVersion().equals(this.getVersion());
        }
        return false;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor iTaskMonitor, String string, File file) {
        String string2;
        String string3;
        if (file != null && file.isDirectory() && (string3 = this.readContentHash(file)) != null && string3.length() > 0 && !string3.equals(string2 = this.computeContentHash(file))) {
            String string4 = archive.getParentPackage().getShortDescription();
            String string5 = String.format("-= Warning ! =-\nYou are about to replace the content of the folder:\n   %1$s\nby the new package:\n  %2$s.\n\nHowever it seems that the content of the existing samples has been modified since it was last installed. Are you sure you want to DELETE the existing samples? This cannot be undone.\nPlease select YES to delete the existing sample and replace them by the new ones.\nPlease select NO to skip this package. You can always install it later.", file.getAbsolutePath(), string4);
            return iTaskMonitor.displayPrompt("SDK Manager: overwrite samples?", string5);
        }
        return super.preInstallHook(archive, iTaskMonitor, string, file);
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor iTaskMonitor, File file) {
        super.postInstallHook(archive, iTaskMonitor, file);
        if (file != null) {
            String string = this.computeContentHash(file);
            this.saveContentHash(file, string);
        }
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor iTaskMonitor, IFileOp iFileOp, File file, ZipArchiveEntry zipArchiveEntry) {
        super.postUnzipFileHook(archive, iTaskMonitor, iFileOp, file, zipArchiveEntry);
        if (iFileOp.isFile(file) && !"source.properties".equals(file.getName())) {
            iFileOp.setReadOnly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentHash(File file) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            File file2 = new File(file, "content_hash.properties");
            if (file2.isFile()) {
                fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
                String string = properties.getProperty("content-hash", null);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContentHash(File file, String string) {
        Properties properties = new Properties();
        properties.setProperty("content-hash", string == null ? "" : string);
        FileOutputStream fileOutputStream = null;
        try {
            File file2 = new File(file, "content_hash.properties");
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, "## Android - hash of this archive.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String computeContentHash(File file) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (messageDigest != null) {
            this.hashDirectoryContent(file, messageDigest);
            return this.getDigestHexString(messageDigest);
        }
        return null;
    }

    private void hashDirectoryContent(File file, MessageDigest messageDigest) {
        if (file == null || messageDigest == null || !file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                this.hashDirectoryContent(file2, messageDigest);
                continue;
            }
            String string = file2.getName();
            if (string == null || "content_hash.properties".equals(string)) continue;
            try {
                messageDigest.update(string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                long l = file2.length();
                messageDigest.update((byte)(l & 0xFFL));
                messageDigest.update((byte)(l >> 8 & 0xFFL));
                messageDigest.update((byte)(l >> 16 & 0xFFL));
                messageDigest.update((byte)(l >> 24 & 0xFFL));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private String getDigestHexString(MessageDigest messageDigest) {
        byte[] byArray = messageDigest.digest();
        int n = byArray.length;
        String string = "0123456789abcdef";
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i * 2 + 0] = string.charAt(n2 >>> 4);
            cArray[i * 2 + 1] = string.charAt(n2 & 0xF);
        }
        return new String(cArray);
    }
}

