/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.impl.cookie;

import com.crashlytics.reloc.org.apache.http.annotation.Immutable;
import com.crashlytics.reloc.org.apache.http.cookie.CookieSpec;
import com.crashlytics.reloc.org.apache.http.cookie.CookieSpecFactory;
import com.crashlytics.reloc.org.apache.http.cookie.CookieSpecProvider;
import com.crashlytics.reloc.org.apache.http.impl.cookie.RFC2109Spec;
import com.crashlytics.reloc.org.apache.http.params.HttpParams;
import com.crashlytics.reloc.org.apache.http.protocol.HttpContext;
import java.util.Collection;

@Immutable
public class RFC2109SpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2109SpecFactory(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public RFC2109SpecFactory() {
        this(null, false);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            boolean singleHeader = params.getBooleanParameter("http.protocol.single-cookie-header", false);
            return new RFC2109Spec(patterns, singleHeader);
        }
        return new RFC2109Spec();
    }

    public CookieSpec create(HttpContext context) {
        return new RFC2109Spec(this.datepatterns, this.oneHeader);
    }
}

