/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.RestfulWebApi;
import com.crashlytics.api.WebApi;
import com.crashlytics.api.ota.DistributionController;
import com.crashlytics.api.ota.ReleaseNotes;
import com.crashlytics.reloc.com.google.common.base.Charsets;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.base.Splitter;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.reloc.com.google.common.io.Files;
import com.crashlytics.reloc.org.apache.commons.cli.Option;
import com.crashlytics.reloc.org.apache.commons.cli.OptionBuilder;
import com.crashlytics.reloc.org.apache.commons.cli.Options;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.ManifestOnboarder;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.DataDirDeobsManager;
import com.crashlytics.tools.android.project.DefaultAndroidBuildHandler;
import com.crashlytics.tools.android.project.DeobsUploader;
import com.crashlytics.tools.android.project.ManifestFileProvider;
import com.crashlytics.tools.android.project.ResourceUpdateData;
import com.crashlytics.tools.android.project.StandardAndroidProjectFactory;
import com.crashlytics.tools.android.project.XmlBuildIdManager;
import com.crashlytics.tools.utils.ApkUtils;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.PropertyConfigurator;

public class DeveloperTools {
    public static final String CRASHLYTICS_JAR = "crashlytics.jar";
    public static final File CRASHLYTICS_DATA_ROOT = DeveloperTools.getAppDataFolder();
    public static final String DEVELOPER_TOOLS_ROOT = "com.crashlytics.tools";
    public static final File CRASHLYTICS_PROJECTS_ROOT = new File(CRASHLYTICS_DATA_ROOT, "com.crashlytics.tools");
    private static final String CRASHLYTICS_HALTED_COMPILATION_BECAUSE = "Crashlytics halted compilation because it ";
    private static final String CRASHLYTICS_FAILED_DEOBS_UPLOAD_REASON = "had a problem uploading the deobs file. Please check network connectivity and try again.";
    private static final String CRASHLYTICS_FAILED_DIST_UPLOAD_REASON = "had a problem uploading the distribution. Please check network connectivity and try again.";
    private static final String CRASHLYTICS_APK_FILE_NOT_FOUND_REASON = "did not find a file to distribute at ";
    private static final String CRASHLYTICS_APK_BUILD_PROPS_REASON = "could not extract Crashlytics build info from the specified APK. Please make sure your Crashlytics build tool plugin is installed and enabled.";
    public static final String STANDARD_LOGGER = "log4j.standard.properties";
    public static final String COMMAND_LINE_LOGGER = "log4j.commandline.properties";
    private static Logger customLogger;
    private static final StandardAndroidProjectFactory PROJECT_FACTORY;
    protected static final String BASE_API_URL_PROP = "crashlytics.webApiUrl";
    protected static final String CODEMAPPING_API_URL_PROP = "crashlytics.cmApiUrl";
    protected static final String OPT_HELP = "help";
    public static final String OPT_GENERATE_RESOURCE_FILE = "generateResourceFile";
    public static final String OPT_CLEANUP_RESOURCE_FILE = "cleanupResourceFile";
    public static final String OPT_NOTIFY_BUILD_EVENT = "buildEvent";
    public static final String OPT_STORE_DEOBS = "storeDeobs";
    protected static final String OPT_STORE_DEOBS_ARG = "file";
    public static final String OPT_UPLOAD_DIST = "uploadDist";
    protected static final String OPT_UPLOAD_DIST_ARG = "file";
    public static final String OPT_BETA_DIST_EMAILS_PATH = "betaDistributionEmailsFilePath";
    protected static final String OPT_BETA_DIST_EMAILS_PATH_ARG = "path";
    public static final String OPT_BETA_DIST_GROUPS_PATH = "betaDistributionGroupShortNamesFilePath";
    protected static final String OPT_BETA_DIST_GROUPS_PATH_ARG = "path";
    public static final String OPT_BETA_DIST_RELEASE_NOTES_PATH = "betaDistributionReleaseNotesFilePath";
    protected static final String OPT_BETA_DIST_RELEASE_NOTES_PATH_ARG = "path";
    public static final String OPT_BETA_DIST_EMAILS = "betaDistributionEmails";
    protected static final String OPT_BETA_DIST_EMAILS_ARG = "emails";
    public static final String OPT_BETA_DIST_GROUPS = "betaDistributionGroupShortNames";
    protected static final String OPT_BETA_DIST_GROUPS_ARG = "shortNames";
    public static final String OPT_BETA_DIST_RELEASE_NOTES = "betaDistributionReleaseNotes";
    protected static final String OPT_BETA_DIST_RELEASE_NOTES_ARG = "notes";
    public static final String OPT_BUILD_SECRET = "apiSecret";
    protected static final String OPT_BUILD_SECRET_ARG = "key";
    public static final String OPT_OBFUSCATING = "obfuscating";
    public static final String OPT_OBFUSCATOR = "obfuscator";
    protected static final String OPT_OBFUSCATOR_ARG = "obfuscatorId";
    public static final String OPT_OBFUSCATOR_VERSION = "obVer";
    protected static final String OPT_OBFUSCATOR_VERSION_ARG = "obfuscatorVersion";
    public static final String OPT_UPLOAD_DEOBS = "uploadDeobs";
    public static final String OPT_PATH = "projectPath";
    protected static final String OPT_PATH_ARG = "path";
    public static final String DEFAULT_PATH = ".";
    public static final String OPT_MANIFEST_PATH = "androidManifest";
    protected static final String OPT_MANIFEST_PATH_ARG = "androidManifestPath";
    public static final String OPT_RES_PATH = "androidRes";
    protected static final String OPT_RES_PATH_ARG = "androidResPath";
    public static final String OPT_RES_FILE = "resFile";
    public static final String OPT_ASSETS_PATH = "androidAssets";
    protected static final String OPT_ASSETS_PATH_ARG = "androidAssetsPath";
    public static final String OPT_RENAMED_PACKAGE = "renamedPackage";
    public static final String OPT_ANDROID_LIBRARY = "androidLibrary";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_QUIET = "quiet";
    public static final String OPT_RESOURCE_CHECK = "resourceCheck";
    public static final String OPT_BUILD_EVENT = "buildEvent";
    public static final String OPT_TOOL_ID = "tool";
    public static final String OPT_TOOL_VERSION = "version";
    public static final String OPT_INJECTABLE_MANIFEST = "injectableManifest";
    public static final String OPT_API_KEY = "apiKey";
    public static final String TOOL_ID_ANT = "com.crashlytics.tools.ant";
    public static final String TOOL_ID_MAVEN = "com.crashlytics.crashlytics-maven";
    public static final String TOOL_ID_GRADLE = "com.crashlytics.tools.gradle.crashlytics-gradle";
    private static final String USER_AGENT_FORMAT = "Crashlytics %s Plugin for";
    private static Map<String, String> _toolIdToName;
    public static final String OPT_MODULES_ENABLED = "modulesEnabled";
    public static final String OPT_REQUIRE_UPLOAD_SUCCESS = "requireUploadSuccess";
    private static String[] VALID_COMMANDS;
    private static final String OPEN_SOURCE_API_KEY_PATTERN = "^0[0]*$";
    protected static final String MANIFEST_API_KEY = "com.crashlytics.ApiKey";
    public static final String TEST_API_KEY = "testkey";
    public static final String STRINGS_API_KEY = "@string/api_key";
    public static final String LOCAL_DATA_SUBDIR = ".data";
    private static final Pattern HEX_PATTERN;
    private static WebApi sharedWebApi;

    private static File getAppDataFolder() {
        String os = System.getProperty("os.name").toUpperCase();
        String dataFile = os.contains("MAC") ? "Library/Caches/com.crashlytics" : ".crashlytics";
        return new File(System.getProperty("user.home"), dataFile);
    }

    public static org.apache.log4j.Logger configureCrashlyticsLogger(File outputDirectory) {
        return DeveloperTools.configureCrashlyticsLogger(outputDirectory, STANDARD_LOGGER);
    }

    public static org.apache.log4j.Logger configureCrashlyticsLogger(File outputDirectory, String logConfigurationPath) {
        System.setProperty("crashlytics.logger.home", new File(outputDirectory.getAbsolutePath(), "crashlytics.log").getAbsolutePath());
        Properties l4jProps = new Properties();
        try {
            l4jProps.load(DeveloperTools.class.getClassLoader().getResourceAsStream(logConfigurationPath));
            PropertyConfigurator.configure(l4jProps);
        }
        catch (IOException e) {
            System.err.println("Logger properties could not be intialized.");
            e.printStackTrace(System.err);
        }
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("com.crashlytics");
        return logger;
    }

    public static WebApi getWebApi() {
        return sharedWebApi;
    }

    public static void setWebApi(WebApi api) {
        if (!"https://api.crashlytics.com".equals(api.getBaseApiUrl())) {
            DeveloperTools.logW("Crashlytics API host: " + api.getBaseApiUrl(), null);
        }
        sharedWebApi = api;
    }

    public static WebApi createWebApi() {
        String baseApiUrl = System.getProperty(BASE_API_URL_PROP, "https://api.crashlytics.com");
        String codeMappingApiUrl = System.getProperty(CODEMAPPING_API_URL_PROP, "https://cm.crashlytics.com");
        return new RestfulWebApi(baseApiUrl, codeMappingApiUrl);
    }

    public static void setLogger(Logger l) {
        customLogger = l;
    }

    public static void logD(String msg) {
        customLogger.logD(msg);
    }

    public static void logI(String msg) {
        customLogger.logI(msg);
    }

    public static void logW(String msg, Throwable t) {
        customLogger.logW(msg, t);
    }

    public static void logE(String msg, Throwable t) {
        customLogger.logE(msg, t);
    }

    public static void logStackW(String msg) {
        DeveloperTools.logW(msg + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    public static void logStackE(String msg) {
        DeveloperTools.logE(msg + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    private static StringBuffer currentStackAsString(int frameStartIndex) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = frameStartIndex; i < trace.length; ++i) {
            sb.append("\t" + trace[i] + "\n");
        }
        return sb;
    }

    public static boolean isValidApiKeyFormat(String probe) {
        if (probe == null) {
            return false;
        }
        if (probe.equals(TEST_API_KEY) || probe.equals(STRINGS_API_KEY)) {
            DeveloperTools.logD("ApiKey is " + probe);
            return true;
        }
        if (probe.length() == 40) {
            return HEX_PATTERN.matcher(probe).matches();
        }
        return false;
    }

    public static boolean isValidBuildSecretFormat(String probe) {
        if (probe == null) {
            return false;
        }
        if (probe.length() == 64) {
            return HEX_PATTERN.matcher(probe).matches();
        }
        return false;
    }

    public static void main(String[] args) {
        DeveloperTools.processArgs(args, COMMAND_LINE_LOGGER);
    }

    public static void processArgs(String[] args) {
        DeveloperTools.processArgs(args, STANDARD_LOGGER);
    }

    private static void processArgs(String[] args, String loggerPath) {
        DeveloperTools.setLogger(new L4JWrappedLogger(DeveloperTools.configureCrashlyticsLogger(CRASHLYTICS_PROJECTS_ROOT, loggerPath)));
        try {
            Options options = DeveloperTools.createOptions();
            DeveloperTools.setWebApi(DeveloperTools.createWebApi());
            Properties properties = PropertiesUtils.processArgs(DeveloperTools.class.getName(), args, options);
            if (properties == null) {
                return;
            }
            DeveloperTools.processProperties(properties);
        }
        catch (AndroidLibraryExecutionException androidLibraryException) {
            throw androidLibraryException;
        }
        catch (PluginException ex) {
            throw ex;
        }
        catch (Exception e) {
            String message = "Crashlytics Developer Tools error.";
            DeveloperTools.logE(message, e);
            throw new PluginException(message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processProperties(Properties properties) throws Exception {
        String buildSecret;
        String apiKey;
        DefaultAndroidBuildHandler buildHandler;
        block33: {
            AndroidProject project;
            String toolVersion;
            String toolId;
            String validCommand;
            DeveloperTools.logD("Invoked Crashlytics Developer Tools with arguments: " + PropertiesUtils.toString(properties));
            boolean hasAtLeastOneValidCommand = false;
            String[] arr$ = VALID_COMMANDS;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; hasAtLeastOneValidCommand |= properties.containsKey(validCommand), ++i$) {
                validCommand = arr$[i$];
            }
            if (!hasAtLeastOneValidCommand) {
                throw new IllegalArgumentException("Required argument(s) missing.");
            }
            if (properties.containsKey(OPT_TOOL_ID) && properties.containsKey(OPT_TOOL_VERSION)) {
                toolId = properties.getProperty(OPT_TOOL_ID);
                toolVersion = properties.getProperty(OPT_TOOL_VERSION);
            } else {
                Package packageInfo = DeveloperTools.class.getPackage();
                toolId = packageInfo.getImplementationTitle();
                toolVersion = packageInfo.getImplementationVersion();
            }
            String osName = System.getProperty("os.name");
            sharedWebApi.setToolId(toolId);
            sharedWebApi.setToolVersion(toolVersion);
            sharedWebApi.setOperatingSystem(osName);
            sharedWebApi.setUserAgent(DeveloperTools.generateUserAgent(toolId, toolVersion, osName));
            try {
                project = PROJECT_FACTORY.create(properties);
            }
            catch (IllegalArgumentException e) {
                if (properties.containsKey(OPT_ANDROID_LIBRARY)) {
                    throw new AndroidLibraryExecutionException("Crashlytics could not parse the Android Project structure.\nIt looks like Crashlytics is being applied to your Android Library! Just remove\napply plugin: 'Crashlytics'\nfrom your library project. If you're looking for Library support, please contact support@crashlytics.com", e);
                }
                throw new IllegalArgumentException("Crashlytics could not parse the Android Project structure. \nContact support@crashlytics.com for assistance.", e);
            }
            DataDirDeobsManager deobsManager = new DataDirDeobsManager(project, XmlBuildIdManager.createManager(project.getResourceFile()));
            buildHandler = new DefaultAndroidBuildHandler(sharedWebApi, project);
            apiKey = project.getApiKey();
            String packageName = project.getPackageName();
            if (apiKey != null && apiKey.matches(OPEN_SOURCE_API_KEY_PATTERN)) {
                DeveloperTools.logD("Crashlytics API key is empty. To enable real-time crash reporting with Crashlytics, visit http://www.crashlytics.com.");
                return;
            }
            if (apiKey == null || !DeveloperTools.isValidApiKeyFormat(apiKey)) {
                String illegalApiKeyMessage = "Crashlytics found an invalid API key: " + apiKey + ". \n";
                if (properties.containsKey(OPT_ANDROID_LIBRARY)) {
                    illegalApiKeyMessage = illegalApiKeyMessage + "It looks like Crashlytics is being applied to your Android Library! Just remove\napply plugin: 'Crashlytics'\nfrom your library project. If you're looking for Library support, please contact support@crashlytics.com";
                    throw new AndroidLibraryExecutionException(illegalApiKeyMessage);
                }
                illegalApiKeyMessage = illegalApiKeyMessage + "Check the Crashlytics plugin to make sure that the application has been added successfully! \nContact support@crashlytics.com for assistance.";
                throw new IllegalArgumentException(illegalApiKeyMessage);
            }
            DeveloperTools.logD("apiKey is " + apiKey);
            buildSecret = project.getBuildSecret();
            boolean buildSecretRequired = properties.containsKey(OPT_UPLOAD_DIST);
            if (buildSecret == null && buildSecretRequired || buildSecret != null && !DeveloperTools.isValidBuildSecretFormat(buildSecret)) {
                throw new IllegalArgumentException("Invalid secret API key: " + buildSecret + ". \nCheck the Crashlytics plugin to make sure that the application has been added successfully! \nContact support@crashlytics.com for assistance.");
            }
            if (properties.containsKey(OPT_RESOURCE_CHECK)) {
                DeveloperTools.logD("Checking for Resource");
                File resourceFile = project.getResourceFile();
                if (!resourceFile.exists()) {
                    String failMessage = packageName != null ? "Your team has updated " + packageName + " to include real-time crash reporting with Crashlytics.\n" + "Confirm you're part of this team and set up Android Studio here:\n" + "https://crashlytics.com/register/" + apiKey + "/android/" + packageName : "Your team has updated this project to include real-time crash reporting with Crashlytics.\nConfirm you're part of this team and set up Android Studio here:\nhttps://crashlytics.com";
                    DeveloperTools.logD(failMessage);
                    throw new PluginException(failMessage);
                }
            }
            if (properties.containsKey(OPT_GENERATE_RESOURCE_FILE)) {
                if (properties.containsKey(OPT_INJECTABLE_MANIFEST) && properties.containsKey(OPT_API_KEY)) {
                    DeveloperTools.logD("Generating crashlytics resources with injected API key");
                    Optional<String> manifestApiKey = project.getManifestData().getApiKey();
                    if (!manifestApiKey.isPresent() || !project.getApiKey().equals(project.getManifestData().getApiKey().get())) {
                        ManifestOnboarder onboarder = new ManifestOnboarder(new ManifestFileProvider(project.getManifestFile()), Optional.of(apiKey), Optional.<Kit>absent(), false);
                        List<CodeChange> manifestChanges = onboarder.getCodeChanges();
                        for (CodeChange change : manifestChanges) {
                            DeveloperTools.logD("Applying changes: " + change);
                            change.applyChange();
                        }
                    }
                } else {
                    DeveloperTools.logD("Generating crashlytics resources");
                }
                ResourceUpdateData updatedResources = buildHandler.updateBuildResources();
                DeveloperTools.logD("Set build id to " + updatedResources.getBuildId());
            }
            if (properties.containsKey(OPT_CLEANUP_RESOURCE_FILE)) {
                DeveloperTools.logD("Cleaning crashlytics resources");
                buildHandler.cleanBuildResources();
            }
            if (properties.containsKey(OPT_OBFUSCATING) && properties.containsKey(OPT_STORE_DEOBS)) {
                DeveloperTools.logD("Caching deobfuscation file");
                File deobsFile = new File(properties.getProperty(OPT_STORE_DEOBS));
                if (!properties.containsKey(OPT_OBFUSCATOR) || !properties.containsKey(OPT_OBFUSCATOR_VERSION)) {
                    throw new IllegalArgumentException("storeDeobs requires obfuscator and obVer");
                }
                if (deobsFile.exists()) {
                    String obfuscator = properties.getProperty(OPT_OBFUSCATOR);
                    String obfuscatorVer = properties.getProperty(OPT_OBFUSCATOR_VERSION);
                    DeveloperTools.logD("Saving deobfuscation file: " + deobsFile);
                    deobsManager.storeDeobfuscationFile(deobsFile, obfuscator, obfuscatorVer);
                } else {
                    DeveloperTools.logD("Crashlytics detected deobfuscation, but did not find a mapping file at " + deobsFile);
                }
            }
            if (properties.containsKey(OPT_UPLOAD_DEOBS)) {
                DeveloperTools.logD("Uploading deobfuscation file");
                boolean hasFiles = deobsManager.hasCachedDeobfuscationFiles();
                DeobsUploader uploader = new DeobsUploader(DeveloperTools.getWebApi());
                if (hasFiles) {
                    boolean requireSuccess = properties.containsKey(OPT_REQUIRE_UPLOAD_SUCCESS);
                    try {
                        boolean result = uploader.uploadDeobfuscationFiles(deobsManager, apiKey);
                        if (result) {
                            DeveloperTools.logD("Deobfuscation file(s) uploaded.");
                            break block33;
                        } else {
                            DeveloperTools.logW("Crashlytics had a problem uploading the deobs file. Please check network connectivity and try again...", null);
                            if (requireSuccess) {
                                throw new PluginException("Crashlytics halted compilation because it had a problem uploading the deobs file. Please check network connectivity and try again...");
                            }
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        DeveloperTools.logW("Crashlytics had a problem uploading the deobs file. Please check network connectivity and try again.", e);
                        if (requireSuccess) {
                            throw new PluginException("Crashlytics halted compilation because it had a problem uploading the deobs file. Please check network connectivity and try again.", e);
                        }
                        break block33;
                    }
                }
                DeveloperTools.logD("Crashlytics found no deobfuscation files.");
            }
        }
        if (properties.containsKey(OPT_UPLOAD_DIST)) {
            String apkPath = properties.getProperty(OPT_UPLOAD_DIST);
            String emails = DeveloperTools.getPropertyValueOrValueFromPropertyPath(OPT_BETA_DIST_EMAILS, OPT_BETA_DIST_EMAILS_PATH, properties);
            String groups = DeveloperTools.getPropertyValueOrValueFromPropertyPath(OPT_BETA_DIST_GROUPS, OPT_BETA_DIST_GROUPS_PATH, properties);
            String releaseNotes = DeveloperTools.getPropertyValueOrValueFromPropertyPath(OPT_BETA_DIST_RELEASE_NOTES, OPT_BETA_DIST_RELEASE_NOTES_PATH, properties);
            DeveloperTools.uploadDistribution(apiKey, buildSecret, apkPath, emails, groups, releaseNotes);
        }
        if (properties.containsKey("buildEvent")) {
            buildHandler.notifyBuildEvent();
        }
    }

    private static String getPropertyValueOrValueFromPropertyPath(String valueProperty, String pathProperty, Properties props) throws IOException {
        String value = props.getProperty(valueProperty);
        String valuePath = props.getProperty(pathProperty);
        if (Strings.isNullOrEmpty(value) && !Strings.isNullOrEmpty(valuePath)) {
            value = Files.toString(new File(valuePath), Charsets.UTF_8);
        }
        return value;
    }

    private static void uploadDistribution(String apiKey, String buildSecret, String apkPath, String emails, String groups, String releaseNotesBody) {
        try {
            DeveloperTools.logD("Uploading distribution at " + apkPath);
            File apkFile = new File(apkPath);
            if (!apkFile.isFile()) {
                String reason = "can't find the specified file: ";
                DeveloperTools.logW("Crashlytics " + reason + apkFile.getAbsolutePath(), null);
                throw new PluginException(CRASHLYTICS_HALTED_COMPILATION_BECAUSE + reason + apkFile.getAbsolutePath(), null);
            }
            if (!ApkUtils.isSigned(apkFile)) {
                String reason = "can't distribute the unsigned APK: ";
                DeveloperTools.logW("Crashlytics " + reason + apkFile.getAbsolutePath(), null);
                throw new PluginException(CRASHLYTICS_HALTED_COMPILATION_BECAUSE + reason + apkFile.getAbsolutePath(), null);
            }
            AppRelease appRelease = ApkUtils.readBuildPropertiesFromApk(apkFile);
            if (appRelease == null) {
                String reason = "can't extract Crashlytics build info from the APK: ";
                DeveloperTools.logW("Crashlytics " + reason + apkFile.getAbsolutePath(), null);
                throw new PluginException(CRASHLYTICS_HALTED_COMPILATION_BECAUSE + reason + apkFile.getAbsolutePath(), null);
            }
            List<String> emailsList = emails == null ? null : DeveloperTools.extractTrimmedStringsFromCommaDelimitedValue(emails);
            List<String> groupsList = groups == null ? null : DeveloperTools.extractTrimmedStringsFromCommaDelimitedValue(groups);
            ReleaseNotes notes = releaseNotesBody == null ? null : new ReleaseNotes("text", releaseNotesBody);
            boolean result = new DistributionController.Builder(DeveloperTools.getWebApi(), apiKey, buildSecret, appRelease, 100).setDistributionFile(apkFile).setEmails(emailsList).setGroupIds(groupsList).setReleaseNotes(notes).build().uploadDistribution();
            if (!result) {
                String reason = "The upload distribution task failed because it received invalid input. Contact support@crashlytics.com for help.";
                DeveloperTools.logW(reason, null);
                throw new PluginException(reason);
            }
            DeveloperTools.logD("Distribution uploaded.");
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics had a problem uploading the distribution. Please check network connectivity and try again.", e);
            throw new PluginException("Crashlytics halted compilation because it had a problem uploading the distribution. Please check network connectivity and try again.", e);
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Crashlytics had a problem uploading the distribution. Please check network connectivity and try again.", e);
            throw new PluginException("Crashlytics halted compilation because it had a problem uploading the distribution. Please check network connectivity and try again.", e);
        }
    }

    private static List<String> extractTrimmedStringsFromCommaDelimitedValue(String value) {
        return Splitter.on(",").omitEmptyStrings().trimResults().splitToList(value);
    }

    private static String generateUserAgent(String toolId, String toolVersion, String osName) {
        String toolName = _toolIdToName.get(toolId);
        toolName = toolName != null ? String.format(USER_AGENT_FORMAT, toolName) : toolId;
        return toolName + " " + osName + "/" + toolVersion;
    }

    protected static Options createOptions() {
        Options options = new Options();
        Option buildId = new Option(OPT_GENERATE_RESOURCE_FILE, "Generate Crashlytics-required resources for the project.");
        Option deleteStrings = new Option(OPT_CLEANUP_RESOURCE_FILE, "Remove Crashlytics-generated resource files");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Store the specified deobfuscation file in preparation for upload.");
        Option saveDeobs = OptionBuilder.create(OPT_STORE_DEOBS);
        Option obfuscating = new Option(OPT_OBFUSCATING, "This build included obfuscation.");
        OptionBuilder.withArgName(OPT_OBFUSCATOR_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify an obfuscator vendor identifier for use with storeDeobs.");
        Option obfuscatorId = OptionBuilder.create(OPT_OBFUSCATOR);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_VERSION_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify the obfuscator vendor software version for use with obfuscator.");
        Option obfuscatorVer = OptionBuilder.create(OPT_OBFUSCATOR_VERSION);
        Option uploadDeobs = new Option(OPT_UPLOAD_DEOBS, "Attempt to upload deobfuscation file(s) to Crashlytics servers.");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        Option uploadDist = OptionBuilder.create(OPT_UPLOAD_DIST);
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        Option distEmailsPath = OptionBuilder.create(OPT_BETA_DIST_EMAILS_PATH);
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        Option distGroupsPath = OptionBuilder.create(OPT_BETA_DIST_GROUPS_PATH);
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        Option distReleaseNotesPath = OptionBuilder.create(OPT_BETA_DIST_RELEASE_NOTES_PATH);
        OptionBuilder.withArgName(OPT_BETA_DIST_EMAILS_ARG);
        OptionBuilder.hasArg();
        Option distEmails = OptionBuilder.create(OPT_BETA_DIST_EMAILS);
        OptionBuilder.withArgName(OPT_BETA_DIST_GROUPS_ARG);
        OptionBuilder.hasArg();
        Option distGroups = OptionBuilder.create(OPT_BETA_DIST_GROUPS);
        OptionBuilder.withArgName(OPT_BETA_DIST_RELEASE_NOTES_ARG);
        OptionBuilder.hasArg();
        Option distReleaseNotes = OptionBuilder.create(OPT_BETA_DIST_RELEASE_NOTES);
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android project root");
        Option projectPath = OptionBuilder.create(OPT_PATH);
        OptionBuilder.withArgName(OPT_MANIFEST_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to AndroidManifest.xml)");
        Option manifestPath = OptionBuilder.create(OPT_MANIFEST_PATH);
        OptionBuilder.withArgName(OPT_RES_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android resources (res/ folder)");
        Option resPath = OptionBuilder.create(OPT_RES_PATH);
        OptionBuilder.withArgName("resFilearg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Override path to current resource file (Instead of using a file relative of the res/ path)");
        Option resFile = OptionBuilder.create(OPT_RES_FILE);
        OptionBuilder.withArgName(OPT_ASSETS_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android assets (assets/ folder)");
        Option assetsPath = OptionBuilder.create(OPT_ASSETS_PATH);
        OptionBuilder.withArgName(OPT_BUILD_SECRET_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("API Secret for the project");
        Option buildSecret = OptionBuilder.create(OPT_BUILD_SECRET);
        Option androidLibrary = new Option(OPT_ANDROID_LIBRARY, "Call came from an Android Library build");
        Option verbose = new Option(OPT_VERBOSE, "Verbose command line output");
        Option quiet = new Option(OPT_QUIET, "Silent command line output");
        Option help = new Option(OPT_HELP, "Display command help.");
        Option check = new Option(OPT_RESOURCE_CHECK, "Check if a resource file already exists.");
        OptionBuilder.withArgName("toolarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Name of the build tool");
        Option toolName = OptionBuilder.create(OPT_TOOL_ID);
        OptionBuilder.withArgName("versionarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Version of the build tool");
        Option toolVersion = OptionBuilder.create(OPT_TOOL_VERSION);
        OptionBuilder.withArgName("propertiesarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Properties file that overrides the input properties");
        Option propertiesPath = OptionBuilder.create("properties");
        Option buildEvent = new Option("buildEvent", "Notify Crashlytics that a build event has occurred");
        Option requireUploadSuccess = new Option(OPT_REQUIRE_UPLOAD_SUCCESS, "Throw an exception if the deobfuscation upload was not successful");
        Option injectableManifest = new Option(OPT_INJECTABLE_MANIFEST, "If the manifest is in a build folder and can be modified during the build.");
        OptionBuilder.withArgName("apiKeyarg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("If the Manifest is injectable, this api key will be added to it.");
        Option apiKey = OptionBuilder.create(OPT_API_KEY);
        OptionBuilder.withArgName("renamedPackagearg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Package name to override the original project package found in the Manifest");
        Option renamedPackage = OptionBuilder.create(OPT_RENAMED_PACKAGE);
        options.addOption(buildId);
        options.addOption(androidLibrary);
        options.addOption(deleteStrings);
        options.addOption(saveDeobs);
        options.addOption(obfuscating);
        options.addOption(obfuscatorId);
        options.addOption(obfuscatorVer);
        options.addOption(uploadDeobs);
        options.addOption(distEmailsPath);
        options.addOption(distGroupsPath);
        options.addOption(distReleaseNotesPath);
        options.addOption(distEmails);
        options.addOption(distGroups);
        options.addOption(distReleaseNotes);
        options.addOption(uploadDist);
        options.addOption(projectPath);
        options.addOption(manifestPath);
        options.addOption(quiet);
        options.addOption(resFile);
        options.addOption(resPath);
        options.addOption(assetsPath);
        options.addOption(buildSecret);
        options.addOption(verbose);
        options.addOption(help);
        options.addOption(check);
        options.addOption(requireUploadSuccess);
        options.addOption(toolName);
        options.addOption(toolVersion);
        options.addOption(buildEvent);
        options.addOption(propertiesPath);
        options.addOption(injectableManifest);
        options.addOption(apiKey);
        options.addOption(renamedPackage);
        return options;
    }

    static {
        if (CRASHLYTICS_DATA_ROOT.isFile()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " is not a directory");
        }
        if (!CRASHLYTICS_DATA_ROOT.exists() && !CRASHLYTICS_DATA_ROOT.mkdir()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " could not be created.");
        }
        customLogger = new StdOutLogger();
        PROJECT_FACTORY = new StandardAndroidProjectFactory();
        _toolIdToName = new HashMap<String, String>(){
            {
                this.put(DeveloperTools.TOOL_ID_ANT, "Ant");
                this.put(DeveloperTools.TOOL_ID_MAVEN, "Maven");
                this.put(DeveloperTools.TOOL_ID_GRADLE, "Gradle");
            }
        };
        VALID_COMMANDS = new String[]{OPT_GENERATE_RESOURCE_FILE, OPT_CLEANUP_RESOURCE_FILE, OPT_STORE_DEOBS, OPT_UPLOAD_DEOBS, OPT_UPLOAD_DIST};
        HEX_PATTERN = Pattern.compile("[0-9a-f]+");
    }

    public static class StdOutLogger
    implements Logger {
        @Override
        public synchronized void logD(String msg) {
            System.out.println("[CLSLOG DEBUG] " + msg);
        }

        @Override
        public synchronized void logI(String msg) {
            System.out.println("[CLSLOG INFO] " + msg);
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            System.out.println("[CLSLOG WARN] " + msg);
            if (t != null) {
                System.err.println(t);
                t.printStackTrace();
            }
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            System.err.println("[CLSLOG ERR] " + msg);
            if (t != null) {
                System.err.println(t);
                t.printStackTrace();
            }
        }
    }

    public static class L4JWrappedLogger
    implements Logger {
        private final org.apache.log4j.Logger _logger;

        public L4JWrappedLogger(org.apache.log4j.Logger logger) {
            this._logger = logger;
        }

        @Override
        public synchronized void logD(String msg) {
            this._logger.debug(msg);
        }

        @Override
        public synchronized void logI(String msg) {
            this._logger.info(msg);
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            this._logger.warn(msg, t);
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            this._logger.error(msg, t);
        }
    }

    public static class MultiLogger
    implements Logger {
        private final Logger[] _loggers;

        public MultiLogger(Logger ... loggers) {
            this._loggers = loggers;
        }

        @Override
        public synchronized void logD(String msg) {
            for (Logger l : this._loggers) {
                l.logD(msg);
            }
        }

        @Override
        public synchronized void logI(String msg) {
            for (Logger l : this._loggers) {
                l.logI(msg);
            }
        }

        @Override
        public synchronized void logW(String msg, Throwable t) {
            for (Logger l : this._loggers) {
                l.logW(msg, t);
            }
        }

        @Override
        public synchronized void logE(String msg, Throwable t) {
            for (Logger l : this._loggers) {
                l.logE(msg, t);
            }
        }
    }

    public static interface Logger {
        public void logD(String var1);

        public void logI(String var1);

        public void logW(String var1, Throwable var2);

        public void logE(String var1, Throwable var2);
    }

    public static class AndroidLibraryExecutionException
    extends RuntimeException {
        public AndroidLibraryExecutionException(String message, Exception parent) {
            super(message, parent);
        }

        public AndroidLibraryExecutionException(String message) {
            super(message);
        }
    }

    public static class PluginException
    extends RuntimeException {
        public PluginException(String message) {
            super(message);
        }

        public PluginException(String message, Exception parent) {
            super(message, parent);
        }
    }
}

