/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.WebApi;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidBuildHandler;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AssetsBuildPropertiesManager;
import com.crashlytics.tools.android.project.BuildIdManager;
import com.crashlytics.tools.android.project.BuildPropertiesManager;
import com.crashlytics.tools.android.project.BuildSecretMaintainer;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ResourceUpdateData;
import com.crashlytics.tools.android.project.XmlBuildIdManager;
import com.crashlytics.tools.utils.NumberUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;

public class DefaultAndroidBuildHandler
implements AndroidBuildHandler {
    public static final String DEFAULT_VERSION_CODE = "0";
    public static final String DEFAULT_VERSION_NAME = "0.0";
    protected final AndroidProject _project;
    private final BuildIdManager _buildIdManager;
    private final BuildSecretMaintainer _buildSecretMaintainer;
    private final BuildPropertiesManager _buildPropertiesManager;
    private WebApi _api;

    public DefaultAndroidBuildHandler(WebApi api, AndroidProject androidProject) {
        this(api, androidProject, XmlBuildIdManager.createManager(androidProject.getResourceFile()), new BuildSecretMaintainer(api, androidProject.getApiKey(), androidProject.getBuildSecret(), androidProject.getPropertiesPath()), new AssetsBuildPropertiesManager(androidProject.getAssetsDir()));
    }

    public DefaultAndroidBuildHandler(WebApi api, AndroidProject project, BuildIdManager buildIdManager, BuildSecretMaintainer buildSecretMaintainer, BuildPropertiesManager buildPropertiesManager) {
        this._api = api;
        this._project = project;
        this._buildIdManager = buildIdManager;
        this._buildSecretMaintainer = buildSecretMaintainer;
        this._buildPropertiesManager = buildPropertiesManager;
    }

    @Override
    public ResourceUpdateData updateBuildResources() throws IOException {
        String versionName;
        UUID buildId = this._buildIdManager.updateBuildId();
        Properties buildProperties = new Properties();
        this._buildSecretMaintainer.maintainBuildSecret();
        ManifestData manifestData = this._project.getManifestData();
        String appName = this._project.getApplicationName();
        String packageName = this._project.getPackageName();
        String versionCode = NumberUtils.toString(manifestData.getVersionCodeOrNull());
        if (Strings.isNullOrEmpty(versionCode)) {
            versionCode = DEFAULT_VERSION_CODE;
        }
        if (Strings.isNullOrEmpty(versionName = manifestData.getVersionName())) {
            versionName = DEFAULT_VERSION_NAME;
        }
        buildProperties = this._buildPropertiesManager.updateBuildProperties(buildId.toString(), appName, packageName, versionCode, versionName);
        return new ResourceUpdateData(buildId, buildProperties);
    }

    @Override
    public void cleanBuildResources() {
        this._buildIdManager.removeBuildId();
        this._buildPropertiesManager.removeBuildProperties();
    }

    @Override
    public void notifyBuildEvent() {
        try {
            this._api.asyncNotifyBuildEvent(this._project.getPackageName(), this._buildIdManager.getBuildId().toString(), this._project.getApiKey(), this._buildSecretMaintainer.getBuildSecret(), this.getDetails());
        }
        catch (Exception e) {
            DeveloperTools.logD("Crashlytics was unable to note a build event");
        }
    }

    protected String getDetails() {
        return null;
    }
}

