/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.project;

import com.crashlytics.reloc.com.android.io.FileWrapper;
import com.crashlytics.reloc.com.android.io.FolderWrapper;
import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.ISdkLog;
import com.crashlytics.reloc.com.android.sdklib.SdkConstants;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.project.ProjectProperties;
import com.crashlytics.reloc.com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.crashlytics.reloc.com.android.sdklib.xml.AndroidManifest;
import com.crashlytics.reloc.com.android.sdklib.xml.AndroidXPathFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCreator {
    private static final int MIN_BUILD_VERSION_TAG = 1;
    private static final String PH_JAVA_FOLDER = "PACKAGE_PATH";
    private static final String PH_PACKAGE = "PACKAGE";
    @Deprecated
    private static final String PH_ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String PH_ACTIVITY_ENTRY_NAME = "ACTIVITY_ENTRY_NAME";
    private static final String PH_ACTIVITY_CLASS_NAME = "ACTIVITY_CLASS_NAME";
    private static final String PH_ACTIVITY_FQ_NAME = "ACTIVITY_FQ_NAME";
    private static final String PH_ACTIVITY_TESTED_CLASS_NAME = "ACTIVITY_TESTED_CLASS_NAME";
    private static final String PH_PROJECT_NAME = "PROJECT_NAME";
    private static final String PH_ICON = "ICON";
    private static final String PH_VERSION_TAG = "VERSION_TAG";
    private static final String XPATH_PROJECT_NAME = "/project/@name";
    public static final Pattern RE_PROJECT_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    public static final String CHARS_PROJECT_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_PACKAGE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)+");
    public static final String CHARS_PACKAGE_NAME = "a-z A-Z 0-9 _";
    public static final Pattern RE_ACTIVITY_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    public static final String CHARS_ACTIVITY_NAME = "a-z A-Z 0-9 _";
    private final OutputLevel mLevel;
    private final ISdkLog mLog;
    private final String mSdkFolder;
    private final SdkManager mSdkManager;

    public ProjectCreator(SdkManager sdkManager, String string, OutputLevel outputLevel, ISdkLog iSdkLog) {
        this.mSdkManager = sdkManager;
        this.mSdkFolder = string;
        this.mLevel = outputLevel;
        this.mLog = iSdkLog;
    }

    public void createProject(String string, String string2, String string3, String string4, IAndroidTarget iAndroidTarget, boolean bl, String string5) {
        File file = this.checkNewProjectLocation(string);
        if (file == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            boolean bl2 = string5 != null;
            ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy = ProjectProperties.create(string, ProjectProperties.PropertyType.LOCAL);
            projectPropertiesWorkingCopy.setProperty("sdk.dir", this.mSdkFolder);
            projectPropertiesWorkingCopy.save();
            ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy2 = ProjectProperties.create(string, ProjectProperties.PropertyType.PROJECT);
            projectPropertiesWorkingCopy2.setProperty("target", iAndroidTarget.hashString());
            if (bl) {
                projectPropertiesWorkingCopy2.setProperty("android.library", "true");
            }
            projectPropertiesWorkingCopy2.save();
            ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy3 = ProjectProperties.create(string, ProjectProperties.PropertyType.ANT);
            if (bl2) {
                projectPropertiesWorkingCopy3.setProperty("tested.project.dir", string5);
            }
            projectPropertiesWorkingCopy3.save();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string6 = ProjectCreator.stripString(string3.replace(".", File.separator), File.separatorChar);
            hashMap.put(PH_JAVA_FOLDER, string6);
            hashMap.put(PH_PACKAGE, string3);
            hashMap.put(PH_VERSION_TAG, Integer.toString(1));
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = string4;
            String string11 = null;
            if (string4 != null) {
                if (bl2) {
                    string4 = string4 + "Test";
                    int n = string10.lastIndexOf(46);
                    string11 = n != -1 ? string10.substring(n + 1) : string10;
                }
                string7 = AndroidManifest.combinePackageAndClassName(string3, string4);
                string8 = ProjectCreator.stripString(string7.replace(".", File.separator), File.separatorChar);
                string8 = string8.substring(0, string8.lastIndexOf(File.separatorChar));
                string9 = string7.substring(string7.lastIndexOf(46) + 1);
            }
            if (iAndroidTarget.getVersion().getApiLevel() < 4) {
                if (string10 != null) {
                    hashMap.put(PH_ACTIVITY_NAME, string10);
                }
            } else if (string4 != null) {
                hashMap.put(PH_ACTIVITY_ENTRY_NAME, string4);
                hashMap.put(PH_ACTIVITY_CLASS_NAME, string9);
                hashMap.put(PH_ACTIVITY_FQ_NAME, string7);
                if (string11 != null) {
                    hashMap.put(PH_ACTIVITY_TESTED_CLASS_NAME, string11);
                }
            }
            if (string2 != null) {
                hashMap.put(PH_PROJECT_NAME, string2);
            } else if (string9 != null) {
                hashMap.put(PH_PROJECT_NAME, string9);
            } else {
                string2 = file.getName();
                hashMap.put(PH_PROJECT_NAME, string2);
            }
            if (string9 != null) {
                String string12 = "src" + File.separator + string8;
                object2 = this.createDirs(file, string12);
                object = bl2 ? "java_tests_file.template" : "java_file.template";
                String string13 = string9 + ".java";
                this.installTargetTemplate((String)object, new File((File)object2, string13), hashMap, iAndroidTarget);
            } else {
                this.createDirs(file, "src");
            }
            File file2 = this.createDirs(file, "res");
            this.createDirs(file, "bin");
            this.createDirs(file, "libs");
            if (!bl2) {
                object2 = this.createDirs(file2, "values");
                this.installTargetTemplate("strings.template", new File((File)object2, "strings.xml"), hashMap, iAndroidTarget);
                object = this.createDirs(file2, "layout");
                this.installTargetTemplate("layout.template", new File((File)object, "main.xml"), hashMap, iAndroidTarget);
                if (this.installIcons(file2, iAndroidTarget)) {
                    hashMap.put(PH_ICON, "android:icon=\"@drawable/ic_launcher\"");
                } else {
                    hashMap.put(PH_ICON, "");
                }
            }
            object2 = "AndroidManifest.template";
            if (bl2) {
                object2 = "AndroidManifest.tests.template";
            }
            this.installTargetTemplate((String)object2, new File(file, "AndroidManifest.xml"), hashMap, iAndroidTarget);
            this.installTemplate("build.template", new File(file, "build.xml"), hashMap);
            this.installTemplate("proguard-project.txt", new File(file, "proguard-project.txt"), null);
        }
        catch (Exception exception) {
            this.mLog.error(exception, null, new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File checkNewProjectLocation(String string) {
        File file = new File(string);
        if (!file.exists()) {
            boolean bl = false;
            Exception exception = null;
            try {
                bl = file.mkdirs();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (bl) {
                this.println("Created project directory: %1$s", file);
                return file;
            }
            this.mLog.error(exception, "Could not create directory: %1$s", file);
            return null;
        }
        Exception exception = null;
        String string2 = null;
        try {
            String[] stringArray = file.list();
            if (stringArray == null) {
                string2 = "Project folder '%1$s' is not a directory.";
            } else if (stringArray.length != 0) {
                string2 = "Project folder '%1$s' is not empty. Please consider using '%2$s update' instead.";
            }
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (exception == null && string2 == null) return file;
        this.mLog.error(exception, string2, file, SdkConstants.androidCmdName());
        return file;
    }

    public boolean updateProject(String string, IAndroidTarget iAndroidTarget, String object, String string2) {
        boolean bl;
        Object object2;
        File file;
        FileWrapper fileWrapper = this.checkProjectFolder(string, "AndroidManifest.xml");
        if (fileWrapper == null) {
            return false;
        }
        FolderWrapper folderWrapper = (FolderWrapper)fileWrapper.getParentFolder();
        boolean bl2 = false;
        IAndroidTarget iAndroidTarget2 = null;
        boolean bl3 = false;
        ProjectProperties projectProperties = ProjectProperties.load(folderWrapper, ProjectProperties.PropertyType.PROJECT);
        if (projectProperties == null) {
            projectProperties = ProjectProperties.load(folderWrapper, ProjectProperties.PropertyType.LEGACY_DEFAULT);
            bl3 = true;
        }
        if (projectProperties != null) {
            String string3 = projectProperties.getProperty("target");
            iAndroidTarget2 = this.mSdkManager.getTargetFromHashString(string3);
            boolean bl4 = bl2 = projectProperties.getProperty("proguard.config") != null;
        }
        if (iAndroidTarget2 == null && iAndroidTarget == null) {
            this.mLog.error(null, "The project either has no target set or the target is invalid.\nPlease provide a --target to the '%1$s update' command.", SdkConstants.androidCmdName());
            return false;
        }
        boolean bl5 = false;
        ProjectPropertiesWorkingCopy projectPropertiesWorkingCopy = null;
        if (iAndroidTarget != null || bl3) {
            projectPropertiesWorkingCopy = projectProperties == null ? ProjectProperties.create(folderWrapper, ProjectProperties.PropertyType.PROJECT) : projectProperties.makeWorkingCopy(ProjectProperties.PropertyType.PROJECT);
            if (iAndroidTarget != null) {
                projectPropertiesWorkingCopy.setProperty("target", iAndroidTarget.hashString());
            }
            bl5 = true;
        }
        if (string2 != null) {
            String string4;
            if (projectPropertiesWorkingCopy == null) {
                assert (projectProperties != null);
                projectPropertiesWorkingCopy = projectProperties.makeWorkingCopy();
            }
            if (!(file = new File(string2)).isAbsolute()) {
                file = new File(folderWrapper, string2);
                try {
                    string4 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    this.mLog.error(iOException, "Unable to resolve path to library project: %1$s", string2);
                    return false;
                }
            } else {
                string4 = file.getAbsolutePath();
            }
            this.println("Resolved location of library project to: %1$s", string4);
            if (this.checkProjectFolder(string4, "AndroidManifest.xml") == null) {
                this.mLog.error(null, "No Android Manifest at: %1$s", string4);
                return false;
            }
            int n = 1;
            while (true) {
                String string5;
                object2 = "android.library.reference." + Integer.toString(n);
                assert (projectProperties != null);
                if (projectProperties == null || (string5 = projectProperties.getProperty((String)object2)) == null) break;
                ++n;
            }
            object2 = "android.library.reference." + Integer.toString(n);
            projectPropertiesWorkingCopy.setProperty((String)object2, string2);
            bl5 = true;
        }
        if (bl5) {
            try {
                assert (projectPropertiesWorkingCopy != null);
                projectPropertiesWorkingCopy.save();
                if (bl3) {
                    this.println("Updated and renamed %1$s to %2$s", ProjectProperties.PropertyType.LEGACY_DEFAULT.getFilename(), ProjectProperties.PropertyType.PROJECT.getFilename());
                } else {
                    this.println("Updated %1$s", ProjectProperties.PropertyType.PROJECT.getFilename());
                }
            }
            catch (Exception exception) {
                this.mLog.error(exception, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.PROJECT.getFilename(), string);
                return false;
            }
            if (bl3) {
                ProjectProperties.delete(folderWrapper, ProjectProperties.PropertyType.LEGACY_DEFAULT);
            }
        }
        projectPropertiesWorkingCopy = (projectProperties = ProjectProperties.load(folderWrapper, ProjectProperties.PropertyType.LOCAL)) == null ? ProjectProperties.create(folderWrapper, ProjectProperties.PropertyType.LOCAL) : projectProperties.makeWorkingCopy();
        projectPropertiesWorkingCopy.setProperty("sdk.dir", this.mSdkFolder);
        try {
            projectPropertiesWorkingCopy.save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.LOCAL.getFilename());
        }
        catch (Exception exception) {
            this.mLog.error(exception, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.LOCAL.getFilename(), string);
            return false;
        }
        projectProperties = ProjectProperties.load(folderWrapper, ProjectProperties.PropertyType.ANT);
        if (projectProperties == null && (projectProperties = ProjectProperties.load(folderWrapper, ProjectProperties.PropertyType.LEGACY_BUILD)) != null) {
            try {
                projectPropertiesWorkingCopy = projectProperties.makeWorkingCopy(ProjectProperties.PropertyType.ANT);
                projectPropertiesWorkingCopy.save();
                ProjectProperties.delete(folderWrapper, ProjectProperties.PropertyType.LEGACY_BUILD);
                this.println("Renamed %1$s to %2$s", ProjectProperties.PropertyType.LEGACY_BUILD.getFilename(), ProjectProperties.PropertyType.ANT.getFilename());
            }
            catch (Exception exception) {
                this.mLog.error(exception, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.ANT.getFilename(), string);
                return false;
            }
        }
        file = new File(folderWrapper, "build.xml");
        boolean bl6 = bl = object != null || !file.exists();
        if (!bl) {
            if (this.checkFileContainsRegexp(file, "version-tag:\\s*custom") != null) {
                this.println("%1$s: Found version-tag: custom. File will not be updated.", "build.xml");
            } else {
                Matcher matcher = this.checkFileContainsRegexp(file, "version-tag:\\s*(\\d+)");
                if (matcher == null) {
                    this.println("----------\n%1$s: Failed to find version-tag string. File must be updated.\nIn order to not erase potential customizations, the file will not be automatically regenerated.\nIf no changes have been made to the file, delete it manually and run the command again.\nIf you have made customizations to the build process, the file must be manually updated.\nIt is recommended to:\n\t* Copy current file to a safe location.\n\t* Delete original file.\n\t* Run command again to generate a new file.\n\t* Port customizations to the new file, by looking at the new rules file\n\t  located at <SDK>/tools/ant/build.xml\n\t* Update file to contain\n\t      version-tag: custom\n\t  to prevent file from being rewritten automatically by the SDK tools.\n----------\n", "build.xml");
                } else {
                    int n;
                    object2 = matcher.group(1);
                    if (object2 != null && (n = Integer.parseInt((String)object2)) < 1) {
                        this.println("%1$s: Found version-tag: %2$d. Expected version-tag: %3$d: file must be updated.", "build.xml", n, 1);
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(PH_VERSION_TAG, Integer.toString(1));
            if (object == null) {
                if (file.exists()) {
                    try {
                        object2 = XPathFactory.newInstance();
                        XPath xPath = ((XPathFactory)object2).newXPath();
                        object = xPath.evaluate(XPATH_PROJECT_NAME, new InputSource(new FileInputStream(file)));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.mLog.error(xPathExpressionException, "Unable to find existing project name from %1$s", "build.xml");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (object == null) {
                    this.extractPackageFromManifest(fileWrapper, hashMap);
                    if (hashMap.containsKey(PH_ACTIVITY_ENTRY_NAME)) {
                        object2 = hashMap.get(PH_ACTIVITY_ENTRY_NAME);
                        int n = ((String)object2).lastIndexOf(46);
                        if (n != -1) {
                            object2 = ((String)object2).substring(n + 1);
                        }
                        object = object2;
                        this.println("No project name specified, using Activity name '%1$s'.\nIf you wish to change it, edit the first line of %2$s.", object2, "build.xml");
                    } else {
                        object2 = folderWrapper;
                        try {
                            object2 = ((File)object2).getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        object = ((File)object2).getName();
                        this.println("No project name specified, using project folder name '%1$s'.\nIf you wish to change it, edit the first line of %2$s.", object, "build.xml");
                    }
                }
            }
            hashMap.put(PH_PROJECT_NAME, (String)object);
            if (this.mLevel == OutputLevel.VERBOSE) {
                this.println("Regenerating %1$s with project name %2$s", "build.xml", hashMap.get(PH_PROJECT_NAME));
            }
            try {
                this.installTemplate("build.template", file, hashMap);
            }
            catch (ProjectCreateException projectCreateException) {
                this.mLog.error(projectCreateException, null, new Object[0]);
                return false;
            }
        }
        if (!bl2) {
            try {
                this.installTemplate("proguard-project.txt", new File(folderWrapper, "proguard-project.txt"), null);
            }
            catch (ProjectCreateException projectCreateException) {
                this.mLog.error(projectCreateException, null, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public void updateTestProject(String string, String string2, SdkManager sdkManager) {
        Object object;
        Object object2;
        String string3;
        if (this.checkProjectFolder(string, "AndroidManifest.xml") == null) {
            return;
        }
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string, string2);
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.mLog.error(iOException, "Unable to resolve path to main project: %1$s", string2);
                return;
            }
        } else {
            string3 = file.getAbsolutePath();
        }
        this.println("Resolved location of main project to: %1$s", string3);
        if (this.checkProjectFolder(string3, "AndroidManifest.xml") == null) {
            this.mLog.error(null, "No Android Manifest at: %1$s", string3);
            return;
        }
        ProjectProperties projectProperties = ProjectProperties.load(string3, ProjectProperties.PropertyType.PROJECT);
        if (projectProperties == null && (projectProperties = ProjectProperties.load(string3, ProjectProperties.PropertyType.LEGACY_DEFAULT)) == null) {
            this.mLog.error(null, "No %1$s at: %2$s", ProjectProperties.PropertyType.PROJECT.getFilename(), string3);
            return;
        }
        String string4 = projectProperties.getProperty("target");
        if (string4 == null) {
            this.mLog.error(null, "%1$s in the main project has no target property.", ProjectProperties.PropertyType.PROJECT.getFilename());
            return;
        }
        IAndroidTarget iAndroidTarget = sdkManager.getTargetFromHashString(string4);
        if (iAndroidTarget == null) {
            this.mLog.error(null, "Main project target %1$s is not a valid target.", string4);
            return;
        }
        String string5 = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        File file2 = new File(string, "build.xml");
        if (!file2.isFile() && ((File)(object2 = new File(string3, "build.xml"))).isFile()) {
            try {
                object = xPath.evaluate(XPATH_PROJECT_NAME, new InputSource(new FileInputStream((File)object2)));
                string5 = (String)object + "Test";
            }
            catch (XPathExpressionException xPathExpressionException) {
                this.mLog.warning("Failed to parse %1$s.\nFile may not be valid. Consider running 'android update project' on the main project.", ((File)object2).getPath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (!this.updateProject(string, iAndroidTarget, string5, null)) {
            return;
        }
        object2 = ProjectProperties.load(string, ProjectProperties.PropertyType.ANT);
        object = object2 == null ? ProjectProperties.create(string, ProjectProperties.PropertyType.ANT) : ((ProjectProperties)object2).makeWorkingCopy();
        ((ProjectPropertiesWorkingCopy)object).setProperty("tested.project.dir", string2);
        try {
            ((ProjectPropertiesWorkingCopy)object).save();
            this.println("Updated %1$s", ProjectProperties.PropertyType.ANT.getFilename());
        }
        catch (Exception exception) {
            this.mLog.error(exception, "Failed to write %1$s file in '%2$s'", ProjectProperties.PropertyType.ANT.getFilename(), string);
            return;
        }
    }

    private FileWrapper checkProjectFolder(String string, String string2) {
        FolderWrapper folderWrapper = new FolderWrapper(string);
        if (!folderWrapper.isDirectory()) {
            this.mLog.error(null, "Project folder '%1$s' is not a valid directory.", folderWrapper);
            return null;
        }
        FileWrapper fileWrapper = new FileWrapper(folderWrapper, string2);
        if (!fileWrapper.isFile()) {
            this.mLog.error(null, "%1$s is not a valid project (%2$s not found).", string, string2);
            return null;
        }
        return fileWrapper;
    }

    private Matcher checkFileContainsRegexp(File file, String string) {
        Pattern pattern = Pattern.compile(string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.find()) continue;
                return matcher;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean extractPackageFromManifest(File file, Map<String, String> map) {
        try {
            XPath xPath = AndroidXPathFactory.newXPath();
            InputSource inputSource = new InputSource(new FileReader(file));
            String string = xPath.evaluate("/manifest/@package", inputSource);
            inputSource = new InputSource(new FileReader(file));
            String string2 = String.format("/manifest/application/activity[intent-filter/action/@%1$s:name='android.intent.action.MAIN' and intent-filter/category/@%1$s:name='android.intent.category.LAUNCHER']/@%1$s:name", "android");
            NodeList nodeList = (NodeList)xPath.evaluate(string2, inputSource, XPathConstants.NODESET);
            if (string == null || string.length() == 0) {
                this.mLog.error(null, "Missing <manifest package=\"...\"> in '%1$s'", file.getName());
                return false;
            }
            String string3 = "";
            if (nodeList.getLength() > 0) {
                string3 = nodeList.item(0).getNodeValue();
            }
            if (this.mLevel == OutputLevel.VERBOSE && nodeList.getLength() > 1) {
                this.println("WARNING: There is more than one activity defined in '%1$s'.\nOnly the first one will be used. If this is not appropriate, you need\nto specify one of these values manually instead:", file.getName());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string4 = nodeList.item(i).getNodeValue();
                    string4 = this.combinePackageActivityNames(string, string4);
                    this.println("- %1$s", string4);
                }
            }
            if (string3.length() == 0) {
                this.mLog.warning("Missing <activity %1$s:name=\"...\"> in '%2$s'.\nNo activity will be generated.", "android", file.getName());
            } else {
                map.put(PH_ACTIVITY_ENTRY_NAME, string3);
            }
            map.put(PH_PACKAGE, string);
            return true;
        }
        catch (IOException iOException) {
            this.mLog.error(iOException, "Failed to read %1$s", file.getName());
        }
        catch (XPathExpressionException xPathExpressionException) {
            Throwable throwable = xPathExpressionException.getCause();
            this.mLog.error(throwable == null ? xPathExpressionException : throwable, "Failed to parse %1$s", file.getName());
        }
        return false;
    }

    private String combinePackageActivityNames(String string, String string2) {
        int n = string2.indexOf(46);
        if (n == 0) {
            return string + string2;
        }
        if (n > 0) {
            return string2;
        }
        return string + "." + string2;
    }

    private void installTargetTemplate(String string, File file, Map<String, String> map, IAndroidTarget iAndroidTarget) throws ProjectCreateException {
        String string2 = iAndroidTarget.getPath(6);
        String string3 = string2 + File.separator + string;
        this.installFullPathTemplate(string3, file, map);
    }

    private void installTemplate(String string, File file, Map<String, String> map) throws ProjectCreateException {
        String string2 = this.mSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
        String string3 = string2 + File.separator + string;
        this.installFullPathTemplate(string3, file, map);
    }

    private void installFullPathTemplate(String string, File file, Map<String, String> map) throws ProjectCreateException {
        boolean bl = file.exists();
        try {
            String string2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        string2 = string2.replace(entry.getKey(), entry.getValue());
                    }
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new ProjectCreateException(exception, "Could not access %1$s: %2$s", file, exception.getMessage());
        }
        this.println("%1$s file %2$s", bl ? "Updated" : "Added", file);
    }

    private boolean installIcons(File file, IAndroidTarget iAndroidTarget) throws ProjectCreateException {
        String string = iAndroidTarget.getPath(6);
        boolean bl = false;
        bl |= this.installIcon(string, "ic_launcher_xhdpi.png", file, "drawable-xhdpi");
        bl |= this.installIcon(string, "ic_launcher_hdpi.png", file, "drawable-hdpi");
        bl |= this.installIcon(string, "ic_launcher_mdpi.png", file, "drawable-mdpi");
        return bl |= this.installIcon(string, "ic_launcher_ldpi.png", file, "drawable-ldpi");
    }

    private boolean installIcon(String string, String string2, File file, String string3) throws ProjectCreateException {
        File file2 = new File(string, string2);
        if (file2.exists()) {
            File file3 = this.createDirs(file, string3);
            this.installBinaryFile(file2, new File(file3, "ic_launcher.png"));
            return true;
        }
        return false;
    }

    private void installBinaryFile(File file, File file2) throws ProjectCreateException {
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            throw new ProjectCreateException(iOException, "Failed to read binary file: %1$s", file.getAbsolutePath());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void println(String string, Object ... objectArray) {
        if (this.mLevel != OutputLevel.SILENT) {
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            this.mLog.printf(string, objectArray);
        }
    }

    private File createDirs(File file, String string) throws ProjectCreateException {
        File file2 = new File(file, string);
        boolean bl = true;
        if (!file2.exists()) {
            if (!file2.mkdirs()) {
                throw new ProjectCreateException("Could not create directory: %1$s", file2);
            }
            bl = false;
        }
        if (file2.isDirectory()) {
            if (!file2.canWrite()) {
                throw new ProjectCreateException("Path is not writable: %1$s", file2);
            }
        } else {
            throw new ProjectCreateException("Path is not a directory: %1$s", file2);
        }
        if (!bl) {
            try {
                this.println("Created directory %1$s", file2.getCanonicalPath());
            }
            catch (IOException iOException) {
                throw new ProjectCreateException("Could not determine canonical path of created directory", new Object[]{iOException});
            }
        }
        return file2;
    }

    private static String stripString(String string, char c) {
        int n;
        int n2 = string.length();
        int n3 = n2 - 1;
        for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
        }
        while (n3 >= 0 && string.charAt(n3) == c) {
            --n3;
        }
        if (n >= n2 || ++n3 < 0) {
            return "";
        }
        return string.substring(n, n3);
    }

    private static class ProjectCreateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ProjectCreateException(String string) {
            super(string);
        }

        ProjectCreateException(Throwable throwable, String string, Object ... objectArray) {
            super(string != null ? String.format(string, objectArray) : string, throwable);
        }

        ProjectCreateException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputLevel {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

